/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrUuid;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class XrUuidEXT
extends XrUuid {
    protected XrUuidEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrUuidEXT create(long address, @Nullable ByteBuffer container) {
        return new XrUuidEXT(address, container);
    }

    public XrUuidEXT(ByteBuffer container) {
        super(container);
    }

    @Override
    public XrUuidEXT data(@NativeType(value="uint8_t[XR_UUID_SIZE]") ByteBuffer value) {
        XrUuidEXT.ndata(this.address(), value);
        return this;
    }

    @Override
    public XrUuidEXT data(int index, @NativeType(value="uint8_t") byte value) {
        XrUuidEXT.ndata(this.address(), index, value);
        return this;
    }

    public XrUuidEXT set(XrUuidEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrUuidEXT malloc() {
        return new XrUuidEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrUuidEXT calloc() {
        return new XrUuidEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrUuidEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrUuidEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrUuidEXT create(long address) {
        return new XrUuidEXT(address, null);
    }

    public static @Nullable XrUuidEXT createSafe(long address) {
        return address == 0L ? null : new XrUuidEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrUuidEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrUuidEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrUuidEXT malloc(MemoryStack stack) {
        return new XrUuidEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrUuidEXT calloc(MemoryStack stack) {
        return new XrUuidEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends XrUuid.Buffer {
        private static final XrUuidEXT ELEMENT_FACTORY = XrUuidEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrUuidEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer data(@NativeType(value="uint8_t[XR_UUID_SIZE]") ByteBuffer value) {
            XrUuidEXT.ndata(this.address(), value);
            return this;
        }

        @Override
        public Buffer data(int index, @NativeType(value="uint8_t") byte value) {
            XrUuidEXT.ndata(this.address(), index, value);
            return this;
        }
    }
}

