/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrViewConfigurationDepthRangeEXT
extends Struct<XrViewConfigurationDepthRangeEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int RECOMMENDEDNEARZ;
    public static final int MINNEARZ;
    public static final int RECOMMENDEDFARZ;
    public static final int MAXFARZ;

    protected XrViewConfigurationDepthRangeEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrViewConfigurationDepthRangeEXT create(long address, @Nullable ByteBuffer container) {
        return new XrViewConfigurationDepthRangeEXT(address, container);
    }

    public XrViewConfigurationDepthRangeEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrViewConfigurationDepthRangeEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrViewConfigurationDepthRangeEXT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrViewConfigurationDepthRangeEXT.nnext(this.address());
    }

    public float recommendedNearZ() {
        return XrViewConfigurationDepthRangeEXT.nrecommendedNearZ(this.address());
    }

    public float minNearZ() {
        return XrViewConfigurationDepthRangeEXT.nminNearZ(this.address());
    }

    public float recommendedFarZ() {
        return XrViewConfigurationDepthRangeEXT.nrecommendedFarZ(this.address());
    }

    public float maxFarZ() {
        return XrViewConfigurationDepthRangeEXT.nmaxFarZ(this.address());
    }

    public XrViewConfigurationDepthRangeEXT type(@NativeType(value="XrStructureType") int value) {
        XrViewConfigurationDepthRangeEXT.ntype(this.address(), value);
        return this;
    }

    public XrViewConfigurationDepthRangeEXT type$Default() {
        return this.type(1000046000);
    }

    public XrViewConfigurationDepthRangeEXT next(@NativeType(value="void *") long value) {
        XrViewConfigurationDepthRangeEXT.nnext(this.address(), value);
        return this;
    }

    public XrViewConfigurationDepthRangeEXT recommendedNearZ(float value) {
        XrViewConfigurationDepthRangeEXT.nrecommendedNearZ(this.address(), value);
        return this;
    }

    public XrViewConfigurationDepthRangeEXT minNearZ(float value) {
        XrViewConfigurationDepthRangeEXT.nminNearZ(this.address(), value);
        return this;
    }

    public XrViewConfigurationDepthRangeEXT recommendedFarZ(float value) {
        XrViewConfigurationDepthRangeEXT.nrecommendedFarZ(this.address(), value);
        return this;
    }

    public XrViewConfigurationDepthRangeEXT maxFarZ(float value) {
        XrViewConfigurationDepthRangeEXT.nmaxFarZ(this.address(), value);
        return this;
    }

    public XrViewConfigurationDepthRangeEXT set(int type, long next, float recommendedNearZ, float minNearZ, float recommendedFarZ, float maxFarZ) {
        this.type(type);
        this.next(next);
        this.recommendedNearZ(recommendedNearZ);
        this.minNearZ(minNearZ);
        this.recommendedFarZ(recommendedFarZ);
        this.maxFarZ(maxFarZ);
        return this;
    }

    public XrViewConfigurationDepthRangeEXT set(XrViewConfigurationDepthRangeEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrViewConfigurationDepthRangeEXT malloc() {
        return new XrViewConfigurationDepthRangeEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrViewConfigurationDepthRangeEXT calloc() {
        return new XrViewConfigurationDepthRangeEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrViewConfigurationDepthRangeEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrViewConfigurationDepthRangeEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrViewConfigurationDepthRangeEXT create(long address) {
        return new XrViewConfigurationDepthRangeEXT(address, null);
    }

    public static @Nullable XrViewConfigurationDepthRangeEXT createSafe(long address) {
        return address == 0L ? null : new XrViewConfigurationDepthRangeEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrViewConfigurationDepthRangeEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrViewConfigurationDepthRangeEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrViewConfigurationDepthRangeEXT malloc(MemoryStack stack) {
        return new XrViewConfigurationDepthRangeEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrViewConfigurationDepthRangeEXT calloc(MemoryStack stack) {
        return new XrViewConfigurationDepthRangeEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static float nrecommendedNearZ(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)RECOMMENDEDNEARZ));
    }

    public static float nminNearZ(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)MINNEARZ));
    }

    public static float nrecommendedFarZ(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)RECOMMENDEDFARZ));
    }

    public static float nmaxFarZ(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)MAXFARZ));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nrecommendedNearZ(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)RECOMMENDEDNEARZ), (float)value);
    }

    public static void nminNearZ(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)MINNEARZ), (float)value);
    }

    public static void nrecommendedFarZ(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)RECOMMENDEDFARZ), (float)value);
    }

    public static void nmaxFarZ(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)MAXFARZ), (float)value);
    }

    static {
        Struct.Layout layout = XrViewConfigurationDepthRangeEXT.__struct((Struct.Member[])new Struct.Member[]{XrViewConfigurationDepthRangeEXT.__member((int)4), XrViewConfigurationDepthRangeEXT.__member((int)POINTER_SIZE), XrViewConfigurationDepthRangeEXT.__member((int)4), XrViewConfigurationDepthRangeEXT.__member((int)4), XrViewConfigurationDepthRangeEXT.__member((int)4), XrViewConfigurationDepthRangeEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        RECOMMENDEDNEARZ = layout.offsetof(2);
        MINNEARZ = layout.offsetof(3);
        RECOMMENDEDFARZ = layout.offsetof(4);
        MAXFARZ = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrViewConfigurationDepthRangeEXT, Buffer>
    implements NativeResource {
        private static final XrViewConfigurationDepthRangeEXT ELEMENT_FACTORY = XrViewConfigurationDepthRangeEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrViewConfigurationDepthRangeEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrViewConfigurationDepthRangeEXT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrViewConfigurationDepthRangeEXT.nnext(this.address());
        }

        public float recommendedNearZ() {
            return XrViewConfigurationDepthRangeEXT.nrecommendedNearZ(this.address());
        }

        public float minNearZ() {
            return XrViewConfigurationDepthRangeEXT.nminNearZ(this.address());
        }

        public float recommendedFarZ() {
            return XrViewConfigurationDepthRangeEXT.nrecommendedFarZ(this.address());
        }

        public float maxFarZ() {
            return XrViewConfigurationDepthRangeEXT.nmaxFarZ(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrViewConfigurationDepthRangeEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000046000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrViewConfigurationDepthRangeEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer recommendedNearZ(float value) {
            XrViewConfigurationDepthRangeEXT.nrecommendedNearZ(this.address(), value);
            return this;
        }

        public Buffer minNearZ(float value) {
            XrViewConfigurationDepthRangeEXT.nminNearZ(this.address(), value);
            return this;
        }

        public Buffer recommendedFarZ(float value) {
            XrViewConfigurationDepthRangeEXT.nrecommendedFarZ(this.address(), value);
            return this;
        }

        public Buffer maxFarZ(float value) {
            XrViewConfigurationDepthRangeEXT.nmaxFarZ(this.address(), value);
            return this;
        }
    }
}

