/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent3DfEXT;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrUuidEXT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrWorldMeshBlockStateML
extends Struct<XrWorldMeshBlockStateML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int UUID;
    public static final int MESHBOUNDINGBOXCENTER;
    public static final int MESHBOUNDINGBOXEXTENTS;
    public static final int LASTUPDATETIME;
    public static final int STATUS;

    protected XrWorldMeshBlockStateML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrWorldMeshBlockStateML create(long address, @Nullable ByteBuffer container) {
        return new XrWorldMeshBlockStateML(address, container);
    }

    public XrWorldMeshBlockStateML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrWorldMeshBlockStateML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrWorldMeshBlockStateML.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrWorldMeshBlockStateML.nnext(this.address());
    }

    public XrUuidEXT uuid() {
        return XrWorldMeshBlockStateML.nuuid(this.address());
    }

    public XrPosef meshBoundingBoxCenter() {
        return XrWorldMeshBlockStateML.nmeshBoundingBoxCenter(this.address());
    }

    public XrExtent3DfEXT meshBoundingBoxExtents() {
        return XrWorldMeshBlockStateML.nmeshBoundingBoxExtents(this.address());
    }

    @NativeType(value="XrTime")
    public long lastUpdateTime() {
        return XrWorldMeshBlockStateML.nlastUpdateTime(this.address());
    }

    @NativeType(value="XrWorldMeshBlockStatusML")
    public int status() {
        return XrWorldMeshBlockStateML.nstatus(this.address());
    }

    public XrWorldMeshBlockStateML type(@NativeType(value="XrStructureType") int value) {
        XrWorldMeshBlockStateML.ntype(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockStateML type$Default() {
        return this.type(1000474003);
    }

    public XrWorldMeshBlockStateML next(@NativeType(value="void *") long value) {
        XrWorldMeshBlockStateML.nnext(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockStateML uuid(XrUuidEXT value) {
        XrWorldMeshBlockStateML.nuuid(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockStateML uuid(Consumer<XrUuidEXT> consumer) {
        consumer.accept(this.uuid());
        return this;
    }

    public XrWorldMeshBlockStateML meshBoundingBoxCenter(XrPosef value) {
        XrWorldMeshBlockStateML.nmeshBoundingBoxCenter(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockStateML meshBoundingBoxCenter(Consumer<XrPosef> consumer) {
        consumer.accept(this.meshBoundingBoxCenter());
        return this;
    }

    public XrWorldMeshBlockStateML meshBoundingBoxExtents(XrExtent3DfEXT value) {
        XrWorldMeshBlockStateML.nmeshBoundingBoxExtents(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockStateML meshBoundingBoxExtents(Consumer<XrExtent3DfEXT> consumer) {
        consumer.accept(this.meshBoundingBoxExtents());
        return this;
    }

    public XrWorldMeshBlockStateML lastUpdateTime(@NativeType(value="XrTime") long value) {
        XrWorldMeshBlockStateML.nlastUpdateTime(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockStateML status(@NativeType(value="XrWorldMeshBlockStatusML") int value) {
        XrWorldMeshBlockStateML.nstatus(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockStateML set(int type, long next, XrUuidEXT uuid, XrPosef meshBoundingBoxCenter, XrExtent3DfEXT meshBoundingBoxExtents, long lastUpdateTime, int status) {
        this.type(type);
        this.next(next);
        this.uuid(uuid);
        this.meshBoundingBoxCenter(meshBoundingBoxCenter);
        this.meshBoundingBoxExtents(meshBoundingBoxExtents);
        this.lastUpdateTime(lastUpdateTime);
        this.status(status);
        return this;
    }

    public XrWorldMeshBlockStateML set(XrWorldMeshBlockStateML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrWorldMeshBlockStateML malloc() {
        return new XrWorldMeshBlockStateML(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrWorldMeshBlockStateML calloc() {
        return new XrWorldMeshBlockStateML(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrWorldMeshBlockStateML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrWorldMeshBlockStateML(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrWorldMeshBlockStateML create(long address) {
        return new XrWorldMeshBlockStateML(address, null);
    }

    public static @Nullable XrWorldMeshBlockStateML createSafe(long address) {
        return address == 0L ? null : new XrWorldMeshBlockStateML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrWorldMeshBlockStateML.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrWorldMeshBlockStateML.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrWorldMeshBlockStateML malloc(MemoryStack stack) {
        return new XrWorldMeshBlockStateML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrWorldMeshBlockStateML calloc(MemoryStack stack) {
        return new XrWorldMeshBlockStateML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static XrUuidEXT nuuid(long struct) {
        return XrUuidEXT.create(struct + (long)UUID);
    }

    public static XrPosef nmeshBoundingBoxCenter(long struct) {
        return XrPosef.create(struct + (long)MESHBOUNDINGBOXCENTER);
    }

    public static XrExtent3DfEXT nmeshBoundingBoxExtents(long struct) {
        return XrExtent3DfEXT.create(struct + (long)MESHBOUNDINGBOXEXTENTS);
    }

    public static long nlastUpdateTime(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)LASTUPDATETIME));
    }

    public static int nstatus(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STATUS));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nuuid(long struct, XrUuidEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)UUID), (long)XrUuidEXT.SIZEOF);
    }

    public static void nmeshBoundingBoxCenter(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MESHBOUNDINGBOXCENTER), (long)XrPosef.SIZEOF);
    }

    public static void nmeshBoundingBoxExtents(long struct, XrExtent3DfEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MESHBOUNDINGBOXEXTENTS), (long)XrExtent3DfEXT.SIZEOF);
    }

    public static void nlastUpdateTime(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)LASTUPDATETIME), (long)value);
    }

    public static void nstatus(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STATUS), (int)value);
    }

    static {
        Struct.Layout layout = XrWorldMeshBlockStateML.__struct((Struct.Member[])new Struct.Member[]{XrWorldMeshBlockStateML.__member((int)4), XrWorldMeshBlockStateML.__member((int)POINTER_SIZE), XrWorldMeshBlockStateML.__member((int)XrUuidEXT.SIZEOF, (int)XrUuidEXT.ALIGNOF), XrWorldMeshBlockStateML.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrWorldMeshBlockStateML.__member((int)XrExtent3DfEXT.SIZEOF, (int)XrExtent3DfEXT.ALIGNOF), XrWorldMeshBlockStateML.__member((int)8), XrWorldMeshBlockStateML.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        UUID = layout.offsetof(2);
        MESHBOUNDINGBOXCENTER = layout.offsetof(3);
        MESHBOUNDINGBOXEXTENTS = layout.offsetof(4);
        LASTUPDATETIME = layout.offsetof(5);
        STATUS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrWorldMeshBlockStateML, Buffer>
    implements NativeResource {
        private static final XrWorldMeshBlockStateML ELEMENT_FACTORY = XrWorldMeshBlockStateML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrWorldMeshBlockStateML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrWorldMeshBlockStateML.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrWorldMeshBlockStateML.nnext(this.address());
        }

        public XrUuidEXT uuid() {
            return XrWorldMeshBlockStateML.nuuid(this.address());
        }

        public XrPosef meshBoundingBoxCenter() {
            return XrWorldMeshBlockStateML.nmeshBoundingBoxCenter(this.address());
        }

        public XrExtent3DfEXT meshBoundingBoxExtents() {
            return XrWorldMeshBlockStateML.nmeshBoundingBoxExtents(this.address());
        }

        @NativeType(value="XrTime")
        public long lastUpdateTime() {
            return XrWorldMeshBlockStateML.nlastUpdateTime(this.address());
        }

        @NativeType(value="XrWorldMeshBlockStatusML")
        public int status() {
            return XrWorldMeshBlockStateML.nstatus(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrWorldMeshBlockStateML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000474003);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrWorldMeshBlockStateML.nnext(this.address(), value);
            return this;
        }

        public Buffer uuid(XrUuidEXT value) {
            XrWorldMeshBlockStateML.nuuid(this.address(), value);
            return this;
        }

        public Buffer uuid(Consumer<XrUuidEXT> consumer) {
            consumer.accept(this.uuid());
            return this;
        }

        public Buffer meshBoundingBoxCenter(XrPosef value) {
            XrWorldMeshBlockStateML.nmeshBoundingBoxCenter(this.address(), value);
            return this;
        }

        public Buffer meshBoundingBoxCenter(Consumer<XrPosef> consumer) {
            consumer.accept(this.meshBoundingBoxCenter());
            return this;
        }

        public Buffer meshBoundingBoxExtents(XrExtent3DfEXT value) {
            XrWorldMeshBlockStateML.nmeshBoundingBoxExtents(this.address(), value);
            return this;
        }

        public Buffer meshBoundingBoxExtents(Consumer<XrExtent3DfEXT> consumer) {
            consumer.accept(this.meshBoundingBoxExtents());
            return this;
        }

        public Buffer lastUpdateTime(@NativeType(value="XrTime") long value) {
            XrWorldMeshBlockStateML.nlastUpdateTime(this.address(), value);
            return this;
        }

        public Buffer status(@NativeType(value="XrWorldMeshBlockStatusML") int value) {
            XrWorldMeshBlockStateML.nstatus(this.address(), value);
            return this;
        }
    }
}

