/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrWorldMeshRequestCompletionInfoML
extends Struct<XrWorldMeshRequestCompletionInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int MESHSPACE;
    public static final int MESHSPACELOCATETIME;

    protected XrWorldMeshRequestCompletionInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrWorldMeshRequestCompletionInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrWorldMeshRequestCompletionInfoML(address, container);
    }

    public XrWorldMeshRequestCompletionInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrWorldMeshRequestCompletionInfoML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrWorldMeshRequestCompletionInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrWorldMeshRequestCompletionInfoML.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long meshSpace() {
        return XrWorldMeshRequestCompletionInfoML.nmeshSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long meshSpaceLocateTime() {
        return XrWorldMeshRequestCompletionInfoML.nmeshSpaceLocateTime(this.address());
    }

    public XrWorldMeshRequestCompletionInfoML type(@NativeType(value="XrStructureType") int value) {
        XrWorldMeshRequestCompletionInfoML.ntype(this.address(), value);
        return this;
    }

    public XrWorldMeshRequestCompletionInfoML type$Default() {
        return this.type(1000474012);
    }

    public XrWorldMeshRequestCompletionInfoML next(@NativeType(value="void const *") long value) {
        XrWorldMeshRequestCompletionInfoML.nnext(this.address(), value);
        return this;
    }

    public XrWorldMeshRequestCompletionInfoML meshSpace(XrSpace value) {
        XrWorldMeshRequestCompletionInfoML.nmeshSpace(this.address(), value);
        return this;
    }

    public XrWorldMeshRequestCompletionInfoML meshSpaceLocateTime(@NativeType(value="XrTime") long value) {
        XrWorldMeshRequestCompletionInfoML.nmeshSpaceLocateTime(this.address(), value);
        return this;
    }

    public XrWorldMeshRequestCompletionInfoML set(int type, long next, XrSpace meshSpace, long meshSpaceLocateTime) {
        this.type(type);
        this.next(next);
        this.meshSpace(meshSpace);
        this.meshSpaceLocateTime(meshSpaceLocateTime);
        return this;
    }

    public XrWorldMeshRequestCompletionInfoML set(XrWorldMeshRequestCompletionInfoML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrWorldMeshRequestCompletionInfoML malloc() {
        return new XrWorldMeshRequestCompletionInfoML(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrWorldMeshRequestCompletionInfoML calloc() {
        return new XrWorldMeshRequestCompletionInfoML(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrWorldMeshRequestCompletionInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrWorldMeshRequestCompletionInfoML(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrWorldMeshRequestCompletionInfoML create(long address) {
        return new XrWorldMeshRequestCompletionInfoML(address, null);
    }

    public static @Nullable XrWorldMeshRequestCompletionInfoML createSafe(long address) {
        return address == 0L ? null : new XrWorldMeshRequestCompletionInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrWorldMeshRequestCompletionInfoML.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrWorldMeshRequestCompletionInfoML.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrWorldMeshRequestCompletionInfoML malloc(MemoryStack stack) {
        return new XrWorldMeshRequestCompletionInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrWorldMeshRequestCompletionInfoML calloc(MemoryStack stack) {
        return new XrWorldMeshRequestCompletionInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nmeshSpace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MESHSPACE));
    }

    public static long nmeshSpaceLocateTime(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)MESHSPACELOCATETIME));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nmeshSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MESHSPACE), (long)value.address());
    }

    public static void nmeshSpaceLocateTime(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)MESHSPACELOCATETIME), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MESHSPACE)));
    }

    static {
        Struct.Layout layout = XrWorldMeshRequestCompletionInfoML.__struct((Struct.Member[])new Struct.Member[]{XrWorldMeshRequestCompletionInfoML.__member((int)4), XrWorldMeshRequestCompletionInfoML.__member((int)POINTER_SIZE), XrWorldMeshRequestCompletionInfoML.__member((int)POINTER_SIZE), XrWorldMeshRequestCompletionInfoML.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        MESHSPACE = layout.offsetof(2);
        MESHSPACELOCATETIME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrWorldMeshRequestCompletionInfoML, Buffer>
    implements NativeResource {
        private static final XrWorldMeshRequestCompletionInfoML ELEMENT_FACTORY = XrWorldMeshRequestCompletionInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrWorldMeshRequestCompletionInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrWorldMeshRequestCompletionInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrWorldMeshRequestCompletionInfoML.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long meshSpace() {
            return XrWorldMeshRequestCompletionInfoML.nmeshSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long meshSpaceLocateTime() {
            return XrWorldMeshRequestCompletionInfoML.nmeshSpaceLocateTime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrWorldMeshRequestCompletionInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000474012);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrWorldMeshRequestCompletionInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer meshSpace(XrSpace value) {
            XrWorldMeshRequestCompletionInfoML.nmeshSpace(this.address(), value);
            return this;
        }

        public Buffer meshSpaceLocateTime(@NativeType(value="XrTime") long value) {
            XrWorldMeshRequestCompletionInfoML.nmeshSpaceLocateTime(this.address(), value);
            return this;
        }
    }
}

