/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent3DfEXT;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrWorldMeshStateRequestInfoML
extends Struct<XrWorldMeshStateRequestInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BASESPACE;
    public static final int TIME;
    public static final int BOUNDINGBOXCENTER;
    public static final int BOUNDINGBOXEXTENTS;

    protected XrWorldMeshStateRequestInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrWorldMeshStateRequestInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrWorldMeshStateRequestInfoML(address, container);
    }

    public XrWorldMeshStateRequestInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrWorldMeshStateRequestInfoML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrWorldMeshStateRequestInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrWorldMeshStateRequestInfoML.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrWorldMeshStateRequestInfoML.nbaseSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrWorldMeshStateRequestInfoML.ntime(this.address());
    }

    public XrPosef boundingBoxCenter() {
        return XrWorldMeshStateRequestInfoML.nboundingBoxCenter(this.address());
    }

    public XrExtent3DfEXT boundingBoxExtents() {
        return XrWorldMeshStateRequestInfoML.nboundingBoxExtents(this.address());
    }

    public XrWorldMeshStateRequestInfoML type(@NativeType(value="XrStructureType") int value) {
        XrWorldMeshStateRequestInfoML.ntype(this.address(), value);
        return this;
    }

    public XrWorldMeshStateRequestInfoML type$Default() {
        return this.type(1000474002);
    }

    public XrWorldMeshStateRequestInfoML next(@NativeType(value="void const *") long value) {
        XrWorldMeshStateRequestInfoML.nnext(this.address(), value);
        return this;
    }

    public XrWorldMeshStateRequestInfoML baseSpace(XrSpace value) {
        XrWorldMeshStateRequestInfoML.nbaseSpace(this.address(), value);
        return this;
    }

    public XrWorldMeshStateRequestInfoML time(@NativeType(value="XrTime") long value) {
        XrWorldMeshStateRequestInfoML.ntime(this.address(), value);
        return this;
    }

    public XrWorldMeshStateRequestInfoML boundingBoxCenter(XrPosef value) {
        XrWorldMeshStateRequestInfoML.nboundingBoxCenter(this.address(), value);
        return this;
    }

    public XrWorldMeshStateRequestInfoML boundingBoxCenter(Consumer<XrPosef> consumer) {
        consumer.accept(this.boundingBoxCenter());
        return this;
    }

    public XrWorldMeshStateRequestInfoML boundingBoxExtents(XrExtent3DfEXT value) {
        XrWorldMeshStateRequestInfoML.nboundingBoxExtents(this.address(), value);
        return this;
    }

    public XrWorldMeshStateRequestInfoML boundingBoxExtents(Consumer<XrExtent3DfEXT> consumer) {
        consumer.accept(this.boundingBoxExtents());
        return this;
    }

    public XrWorldMeshStateRequestInfoML set(int type, long next, XrSpace baseSpace, long time, XrPosef boundingBoxCenter, XrExtent3DfEXT boundingBoxExtents) {
        this.type(type);
        this.next(next);
        this.baseSpace(baseSpace);
        this.time(time);
        this.boundingBoxCenter(boundingBoxCenter);
        this.boundingBoxExtents(boundingBoxExtents);
        return this;
    }

    public XrWorldMeshStateRequestInfoML set(XrWorldMeshStateRequestInfoML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrWorldMeshStateRequestInfoML malloc() {
        return new XrWorldMeshStateRequestInfoML(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrWorldMeshStateRequestInfoML calloc() {
        return new XrWorldMeshStateRequestInfoML(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrWorldMeshStateRequestInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrWorldMeshStateRequestInfoML(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrWorldMeshStateRequestInfoML create(long address) {
        return new XrWorldMeshStateRequestInfoML(address, null);
    }

    public static @Nullable XrWorldMeshStateRequestInfoML createSafe(long address) {
        return address == 0L ? null : new XrWorldMeshStateRequestInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrWorldMeshStateRequestInfoML.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrWorldMeshStateRequestInfoML.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrWorldMeshStateRequestInfoML malloc(MemoryStack stack) {
        return new XrWorldMeshStateRequestInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrWorldMeshStateRequestInfoML calloc(MemoryStack stack) {
        return new XrWorldMeshStateRequestInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BASESPACE));
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)TIME));
    }

    public static XrPosef nboundingBoxCenter(long struct) {
        return XrPosef.create(struct + (long)BOUNDINGBOXCENTER);
    }

    public static XrExtent3DfEXT nboundingBoxExtents(long struct) {
        return XrExtent3DfEXT.create(struct + (long)BOUNDINGBOXEXTENTS);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BASESPACE), (long)value.address());
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)TIME), (long)value);
    }

    public static void nboundingBoxCenter(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)BOUNDINGBOXCENTER), (long)XrPosef.SIZEOF);
    }

    public static void nboundingBoxExtents(long struct, XrExtent3DfEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)BOUNDINGBOXEXTENTS), (long)XrExtent3DfEXT.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BASESPACE)));
    }

    static {
        Struct.Layout layout = XrWorldMeshStateRequestInfoML.__struct((Struct.Member[])new Struct.Member[]{XrWorldMeshStateRequestInfoML.__member((int)4), XrWorldMeshStateRequestInfoML.__member((int)POINTER_SIZE), XrWorldMeshStateRequestInfoML.__member((int)POINTER_SIZE), XrWorldMeshStateRequestInfoML.__member((int)8), XrWorldMeshStateRequestInfoML.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrWorldMeshStateRequestInfoML.__member((int)XrExtent3DfEXT.SIZEOF, (int)XrExtent3DfEXT.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BASESPACE = layout.offsetof(2);
        TIME = layout.offsetof(3);
        BOUNDINGBOXCENTER = layout.offsetof(4);
        BOUNDINGBOXEXTENTS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrWorldMeshStateRequestInfoML, Buffer>
    implements NativeResource {
        private static final XrWorldMeshStateRequestInfoML ELEMENT_FACTORY = XrWorldMeshStateRequestInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrWorldMeshStateRequestInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrWorldMeshStateRequestInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrWorldMeshStateRequestInfoML.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrWorldMeshStateRequestInfoML.nbaseSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrWorldMeshStateRequestInfoML.ntime(this.address());
        }

        public XrPosef boundingBoxCenter() {
            return XrWorldMeshStateRequestInfoML.nboundingBoxCenter(this.address());
        }

        public XrExtent3DfEXT boundingBoxExtents() {
            return XrWorldMeshStateRequestInfoML.nboundingBoxExtents(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrWorldMeshStateRequestInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000474002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrWorldMeshStateRequestInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrWorldMeshStateRequestInfoML.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrWorldMeshStateRequestInfoML.ntime(this.address(), value);
            return this;
        }

        public Buffer boundingBoxCenter(XrPosef value) {
            XrWorldMeshStateRequestInfoML.nboundingBoxCenter(this.address(), value);
            return this;
        }

        public Buffer boundingBoxCenter(Consumer<XrPosef> consumer) {
            consumer.accept(this.boundingBoxCenter());
            return this;
        }

        public Buffer boundingBoxExtents(XrExtent3DfEXT value) {
            XrWorldMeshStateRequestInfoML.nboundingBoxExtents(this.address(), value);
            return this;
        }

        public Buffer boundingBoxExtents(Consumer<XrExtent3DfEXT> consumer) {
            consumer.accept(this.boundingBoxExtents());
            return this;
        }
    }
}

