#version 150

#moj_import <minecraft:fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 baseColor = texture(Sampler0, texCoord0);

#ifdef ALPHA_CUTOUT
    if (baseColor.a < ALPHA_CUTOUT) {
        discard;
    }
#endif

    baseColor *= vertexColor * ColorModulator;

#ifndef NO_OVERLAY
    baseColor.rgb = mix(overlayColor.rgb, baseColor.rgb, overlayColor.a);
#endif

#ifndef EMISSIVE
    baseColor *= lightMapColor;
#endif

    // Aplicar niebla al color base
    fragColor = linear_fog(baseColor, vertexDistance, FogStart, FogEnd, FogColor);

    // Hacer que los píxeles con opacidad de 254 sean brillantes
    float opacity = ceil(baseColor.a * 255.0);
    if (opacity == 254.0) {
        fragColor = linear_fog(texture(Sampler0, texCoord0), vertexDistance, FogStart, FogEnd, FogColor);
    }
}
