#version 150

#moj_import <minecraft:fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec2 texCoord1;
in vec2 texCoord2;

out vec4 fragColor;

void main() {
    vec4 color         = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
    vec4 emissiveColor = texture(Sampler0, texCoord0); // usado para emisión

    if (color.a < vertexColor.a) {
        discard;
    }

    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);

    float opacity = ceil(color.a * 255.0);
    if (opacity == 254.0) {
        fragColor = linear_fog(emissiveColor, vertexDistance, FogStart, FogEnd, FogColor);
    }
}
