/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.manymobs.libs.annoyingapi;

import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.manymobs.libs.annoyingapi.AnnoyingListener;
import xyz.srnyx.manymobs.libs.annoyingapi.AnnoyingReflections;
import xyz.srnyx.manymobs.libs.annoyingapi.AnnoyingStats;
import xyz.srnyx.manymobs.libs.annoyingapi.AnnoyingUpdate;
import xyz.srnyx.manymobs.libs.annoyingapi.command.selector.SelectorManager;
import xyz.srnyx.manymobs.libs.annoyingapi.cooldown.CooldownManager;
import xyz.srnyx.manymobs.libs.annoyingapi.dependency.AnnoyingDependency;
import xyz.srnyx.manymobs.libs.annoyingapi.dependency.AnnoyingDownload;
import xyz.srnyx.manymobs.libs.annoyingapi.events.AdvancedPlayerMoveEvent;
import xyz.srnyx.manymobs.libs.annoyingapi.events.PlayerDamageByPlayerEvent;
import xyz.srnyx.manymobs.libs.annoyingapi.file.AnnoyingResource;
import xyz.srnyx.manymobs.libs.annoyingapi.library.AnnoyingLibraryManager;
import xyz.srnyx.manymobs.libs.annoyingapi.library.RuntimeLibrary;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.MapGenerator;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.objects.SemanticVersion;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.libby.relocation.Relocation;
import xyz.srnyx.manymobs.libs.annoyingapi.options.AnnoyingOptions;
import xyz.srnyx.manymobs.libs.annoyingapi.parents.Registrable;
import xyz.srnyx.manymobs.libs.annoyingapi.scheduler.AnnoyingScheduler;
import xyz.srnyx.manymobs.libs.annoyingapi.storage.ConnectionException;
import xyz.srnyx.manymobs.libs.annoyingapi.storage.DataManager;
import xyz.srnyx.manymobs.libs.annoyingapi.storage.StorageConfig;
import xyz.srnyx.manymobs.libs.annoyingapi.storage.dialects.sql.SQLDialect;
import xyz.srnyx.manymobs.libs.annoyingapi.utility.BukkitUtility;

public class AnnoyingPlugin
extends JavaPlugin {
    @NotNull
    public static Logger LOGGER = new Logger("AnnoyingAPI - ?", null){

        @Override
        public void log(@NotNull LogRecord logRecord) {
            logRecord.setMessage("[AnnoyingAPI - ?] " + logRecord.getMessage());
            super.log(logRecord);
        }
    };
    @NotNull
    public static final SemanticVersion MINECRAFT_VERSION = new SemanticVersion(Bukkit.getVersion().split("MC: ")[1].split("\\)")[0]);
    public static boolean FOLIA = false;
    @NotNull
    public final AnnoyingOptions options = AnnoyingOptions.load(this.getResource("plugin.yml"));
    @NotNull
    public final AnnoyingLibraryManager libraryManager = new AnnoyingLibraryManager(this, "libs");
    @Nullable
    public AnnoyingStats stats;
    @Nullable
    public AnnoyingResource messages;
    @NotNull
    public final Map<String, String> globalPlaceholders = new HashMap<String, String>();
    @Nullable
    public DataManager dataManager;
    @NotNull
    public final Set<Registrable> registeredClasses = new HashSet<Registrable>();
    @NotNull
    public final Map<Class<? extends Event>, AnnoyingListener> customEvents = MapGenerator.HASH_MAP.mapOf(AdvancedPlayerMoveEvent.class, new AdvancedPlayerMoveEvent.Handler(this), PlayerDamageByPlayerEvent.class, new PlayerDamageByPlayerEvent.Handler(this));
    @NotNull
    public final SelectorManager selectorManager = new SelectorManager(this);
    @NotNull
    public final CooldownManager cooldownManager = new CooldownManager();
    @NotNull
    public final AnnoyingScheduler scheduler = new AnnoyingScheduler(this);
    public boolean papiInstalled = false;

    public AnnoyingPlugin() {
        LOGGER = this.getLogger();
    }

    public final void onLoad() {
        this.selectorManager.registerSelectors();
        this.loadMessages();
        this.loadDataManger(null, false);
        this.load();
    }

    public final void onEnable() {
        ArrayList<AnnoyingDependency> missingDependencies = new ArrayList<AnnoyingDependency>();
        for (AnnoyingDependency dependency : this.options.pluginOptions.dependencies) {
            if (!dependency.isNotInstalled() || !missingDependencies.stream().noneMatch(dep -> dep.name.equals(dependency.name))) continue;
            missingDependencies.add(dependency);
        }
        if (!missingDependencies.isEmpty()) {
            AnnoyingPlugin.log(Level.WARNING, "&6&lMissing dependencies! &eAnnoying API will attempt to download/install them...");
            new AnnoyingDownload(this, missingDependencies).downloadPlugins(this::enablePlugin);
            return;
        }
        this.enablePlugin();
    }

    public final void onDisable() {
        if (this.dataManager != null) {
            if (this.dataManager.storageConfig.cache.saveOn.contains((Object)StorageConfig.SaveOn.DISABLE)) {
                this.dataManager.dialect.saveCache();
            }
            if (this.dataManager.dialect instanceof SQLDialect) {
                try {
                    ((SQLDialect)this.dataManager.dialect).connection.close();
                }
                catch (SQLException e) {
                    AnnoyingPlugin.log(Level.SEVERE, "&cFailed to close the database connection", e);
                }
            }
        }
        this.disable();
    }

    public void load() {
    }

    public void enable() {
    }

    public void disable() {
    }

    public void reload() {
    }

    private void enablePlugin() {
        Set<String> packages;
        String primaryColorString;
        String name = this.getName();
        if (name.equals("AnnoyingAPI")) {
            String hideMessage = "";
            try {
                hideMessage = " To hide this message: delete &4" + new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            AnnoyingPlugin.log(Level.SEVERE, "&cDisabling &4AnnoyingAPI&c because it's not meant to be used as a standalone plugin, your plugins will still work!" + hideMessage);
            this.disablePlugin();
            return;
        }
        String missing = this.options.pluginOptions.dependencies.stream().filter(dependency -> dependency.required && dependency.isNotInstalled()).map(dependency -> dependency.name).collect(Collectors.joining("&c, &4"));
        if (!missing.isEmpty()) {
            AnnoyingPlugin.log(Level.SEVERE, "&cDisabling &4" + name + "&c because it's missing required dependencies: &4" + missing);
            this.disablePlugin();
            return;
        }
        this.options.pluginOptions.libraries.forEach(this.libraryManager::loadLibrary);
        if (new AnnoyingResource(this, this.options.bStatsOptions.fileName, this.options.bStatsOptions.fileOptions).getBoolean(this.options.bStatsOptions.toggleKey)) {
            this.libraryManager.loadLibrary(RuntimeLibrary.BSTATS_BASE);
            this.libraryManager.loadLibrary(RuntimeLibrary.BSTATS_BUKKIT);
            this.stats = new AnnoyingStats(this);
        }
        String primaryColor = (primaryColorString = this.globalPlaceholders.get("p")) != null ? BukkitUtility.color(primaryColorString) : ChatColor.AQUA.toString();
        String secondaryColorString = this.globalPlaceholders.get("s");
        String secondaryColor = secondaryColorString != null ? BukkitUtility.color(secondaryColorString) : ChatColor.DARK_AQUA.toString();
        PluginDescriptionFile description = this.getDescription();
        String nameVersion = name + " v" + description.getVersion();
        String authors = "By " + String.join((CharSequence)", ", description.getAuthors());
        StringBuilder lineBuilder = new StringBuilder(secondaryColor);
        int lineLength = Math.max(nameVersion.length(), authors.length());
        for (int i = 0; i < lineLength; ++i) {
            lineBuilder.append("-");
        }
        String line = lineBuilder.toString();
        AnnoyingPlugin.log(Level.INFO, line);
        AnnoyingPlugin.log(Level.INFO, primaryColor + nameVersion);
        AnnoyingPlugin.log(Level.INFO, primaryColor + authors);
        AnnoyingPlugin.log(Level.INFO, line);
        this.checkUpdate();
        this.options.registrationOptions.toRegister.forEach(Registrable::register);
        this.papiInstalled = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
        if (this.papiInstalled) {
            this.options.registrationOptions.getPapiExpansionToRegister().ifPresent(PlaceholderExpansion::register);
        }
        if (!(packages = this.options.registrationOptions.automaticRegistration.packages).isEmpty()) {
            this.libraryManager.loadLibrary(RuntimeLibrary.JAVASSIST);
            this.libraryManager.loadLibrary(RuntimeLibrary.REFLECTIONS);
            Set<Class<? extends Registrable>> ignoredClasses = this.options.registrationOptions.automaticRegistration.ignoredClasses;
            AnnoyingReflections.getSubTypesOf(packages, Registrable.class).stream().filter(clazz -> !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers()) && !clazz.isAnnotationPresent(Registrable.Ignore.class) && !ignoredClasses.contains(clazz)).forEach(clazz -> {
                try {
                    ((Registrable)clazz.getConstructor(((Object)((Object)this)).getClass()).newInstance(new Object[]{this})).register();
                }
                catch (Throwable t) {
                    AnnoyingPlugin.log(Level.WARNING, "&eFailed to register &6" + clazz.getSimpleName(), t);
                }
            });
        }
        if (this.dataManager != null) {
            this.dataManager.toggleIntervalCacheSaving();
        }
        this.enable();
    }

    public void disablePlugin() {
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    public void reloadPlugin() {
        this.loadMessages();
        StorageConfig storageConfig = null;
        boolean saveCache = false;
        if (this.options.dataOptions.enabled) {
            storageConfig = new StorageConfig(new AnnoyingResource(this, "storage.yml"));
            saveCache = storageConfig.cache.saveOn.contains((Object)StorageConfig.SaveOn.RELOAD) || this.dataManager != null && this.dataManager.storageConfig.cache.enabled && !storageConfig.cache.enabled;
        }
        this.loadDataManger(storageConfig, saveCache);
        if (this.dataManager != null) {
            this.dataManager.toggleIntervalCacheSaving();
        }
        this.reload();
    }

    public void loadMessages() {
        this.messages = new AnnoyingResource(this, this.options.messagesOptions.fileName, this.options.messagesOptions.fileOptions);
        this.globalPlaceholders.clear();
        ConfigurationSection section = this.messages.getConfigurationSection(this.options.messagesOptions.keys.globalPlaceholders);
        if (section != null) {
            section.getKeys(false).forEach(key -> this.globalPlaceholders.put((String)key, section.getString(key)));
        }
    }

    @NotNull
    public String getMessagesString(@NotNull String key) {
        return this.messages != null ? this.messages.getString(key, key) : key;
    }

    @NotNull
    public String parsePapiPlaceholders(@Nullable OfflinePlayer player, @Nullable String message) {
        if (message == null) {
            return "null";
        }
        return this.papiInstalled ? PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)message) : message;
    }

    public void unregisterClasses() {
        new HashSet<Registrable>(this.registeredClasses).forEach(Registrable::unregister);
    }

    public void checkUpdate() {
        new AnnoyingUpdate(this, this.options.pluginOptions.updatePlatforms).checkUpdate();
    }

    public void loadDataManger(@Nullable StorageConfig storageConfig, boolean saveCache) {
        if (this.dataManager != null) {
            if (saveCache) {
                this.dataManager.dialect.saveCache();
            }
            if (this.dataManager.dialect instanceof SQLDialect) {
                try {
                    ((SQLDialect)this.dataManager.dialect).connection.close();
                }
                catch (SQLException e) {
                    AnnoyingPlugin.log(Level.SEVERE, "&cFailed to close the database connection, it's recommended to restart the server!", e);
                }
            }
            if (this.dataManager.cacheSavingTask != null) {
                this.dataManager.cacheSavingTask.cancel();
            }
        }
        if (!this.options.dataOptions.enabled) {
            this.dataManager = null;
            return;
        }
        try {
            this.dataManager = new DataManager(storageConfig == null ? new StorageConfig(new AnnoyingResource(this, "storage.yml")) : storageConfig);
        }
        catch (ConnectionException e) {
            this.dataManager = null;
            AnnoyingPlugin.log(Level.SEVERE, "&4storage.yml &8|&c Failed to connect to database! URL: '&4" + e.url + "&c' Properties: &4" + e.getPropertiesRedacted(), e);
            return;
        }
        this.dataManager = this.dataManager.attemptDatabaseMigration();
        if (this.dataManager.dialect instanceof SQLDialect) {
            HashMap<String, Set<String>> tablesCopy = new HashMap<String, Set<String>>(this.options.dataOptions.tables);
            Set entitiesTable = (Set)tablesCopy.get("entities");
            if (entitiesTable != null && entitiesTable.size() == 1) {
                tablesCopy.remove("entities");
            }
            ((SQLDialect)this.dataManager.dialect).createTablesKeys(tablesCopy);
        }
    }

    @NotNull
    public Relocation getRelocation(@NotNull String from, @NotNull String name) {
        return new Relocation(from, this.getLibsPackage() + name);
    }

    @NotNull
    public Relocation getRelocation(@NotNull String from) {
        return this.getRelocation(from, from.substring(from.lastIndexOf("{}") + 2).toLowerCase().replaceAll("[^a-z0-9._{}]", ""));
    }

    @NotNull
    public String getLibsPackage() {
        return ((Object)((Object)this)).getClass().getPackage().getName() + "{}libs{}";
    }

    public static void log(@Nullable Level level, @Nullable Object message, @Nullable Throwable throwable) {
        if (level == null) {
            level = Level.INFO;
        }
        LOGGER.log(level, MINECRAFT_VERSION.isGreaterThanOrEqualTo(1, 12, 0) && MINECRAFT_VERSION.isLessThanOrEqualTo(1, 20, 0) ? BukkitUtility.color(message) : BukkitUtility.stripUntranslatedColor(String.valueOf(message)), throwable);
    }

    public static void log(@Nullable Level level, @Nullable Object message) {
        AnnoyingPlugin.log(level, message, null);
    }

    public static void log(@Nullable Object message) {
        AnnoyingPlugin.log(null, message, null);
    }

    @NotNull
    public static String replaceBrackets(@NotNull String string) {
        return string.replace("{}", ".");
    }

    static {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            FOLIA = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

