/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.manymobs.libs.annoyingapi.data;

import java.util.Optional;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.manymobs.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.parents.Stringable;
import xyz.srnyx.manymobs.libs.annoyingapi.parents.Annoyable;
import xyz.srnyx.manymobs.libs.annoyingapi.utility.BukkitUtility;

public abstract class Data<T>
extends Stringable
implements Annoyable {
    @NotNull
    protected final AnnoyingPlugin plugin;
    @NotNull
    public final T target;

    protected Data(@NotNull AnnoyingPlugin plugin, @NotNull T target) {
        this.plugin = plugin;
        this.target = target;
    }

    @Override
    @NotNull
    public AnnoyingPlugin getAnnoyingPlugin() {
        return this.plugin;
    }

    public boolean has(@NotNull String key) {
        return this.get(key) != null;
    }

    @Nullable
    public abstract String get(@NotNull String var1);

    @NotNull
    public String get(@NotNull String key, @NotNull String def) {
        String value = this.get(key);
        return value == null ? def : value;
    }

    @NotNull
    public Optional<String> getOptional(@NotNull String key) {
        return Optional.ofNullable(this.get(key));
    }

    protected abstract boolean set(@NotNull String var1, @NotNull String var2);

    public boolean set(@NotNull String key, @Nullable Object value) {
        return value == null ? this.remove(key) : this.set(key, value.toString());
    }

    @NotNull
    public Data<T> setChain(@NotNull String key, @Nullable Object value) {
        this.set(key, value);
        return this;
    }

    public abstract boolean remove(@NotNull String var1);

    @NotNull
    public Data<T> removeChain(@NotNull String key) {
        this.remove(key);
        return this;
    }

    protected void sendError(@NotNull String action, @Nullable Throwable t) {
        AnnoyingPlugin.log(Level.WARNING, "&cFailed to " + action + " data for &4" + BukkitUtility.stripUntranslatedColor(this.target.toString()) + "&c!", t);
    }
}

