/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.manymobs.libs.annoyingapi.events;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.manymobs.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.manymobs.libs.annoyingapi.events.CustomEventHandler;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.parents.Stringable;
import xyz.srnyx.manymobs.libs.annoyingapi.parents.Registrable;

public class AdvancedPlayerMoveEvent
extends PlayerMoveEvent {
    @NotNull
    private static final HandlerList HANDLERS = new HandlerList();
    @Nullable
    private MovementType movementType;

    public AdvancedPlayerMoveEvent(@NotNull Player player, @NotNull Location from, @Nullable Location to) {
        super(player, from, to);
    }

    public AdvancedPlayerMoveEvent(@NotNull PlayerMoveEvent event) {
        this(event.getPlayer(), event.getFrom(), event.getTo());
        this.setCancelled(event.isCancelled());
    }

    @NotNull
    public String toString() {
        return Stringable.toString((Object)this);
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    @NotNull
    public HandlerList getHandlers() {
        return AdvancedPlayerMoveEvent.getHandlerList();
    }

    @NotNull
    public MovementType getMovementType() {
        if (this.movementType != null) {
            return this.movementType;
        }
        Location from = this.getFrom();
        Location to = this.getTo();
        if (to == null) {
            return MovementType.TRANSLATION;
        }
        this.movementType = from.getYaw() == to.getYaw() && from.getPitch() == to.getPitch() ? MovementType.TRANSLATION : (from.getX() == to.getX() && from.getY() == to.getY() && from.getZ() == to.getZ() ? MovementType.ROTATION : MovementType.BOTH);
        return this.movementType;
    }

    public static enum MovementType {
        TRANSLATION,
        ROTATION,
        BOTH;

    }

    @Registrable.Ignore
    public static class Handler
    extends CustomEventHandler {
        public Handler(@NotNull AnnoyingPlugin plugin) {
            super(plugin);
        }

        @EventHandler
        public void onPlayerMove(@NotNull PlayerMoveEvent event) {
            AdvancedPlayerMoveEvent newEvent = new AdvancedPlayerMoveEvent(event);
            Bukkit.getPluginManager().callEvent((Event)newEvent);
            event.setCancelled(newEvent.isCancelled());
            event.setFrom(newEvent.getFrom());
            Location to = newEvent.getTo();
            if (to != null) {
                event.setTo(to);
            }
        }
    }
}

