/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.manymobs.libs.annoyingapi.storage.dialects.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.manymobs.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.manymobs.libs.annoyingapi.storage.ConnectionException;
import xyz.srnyx.manymobs.libs.annoyingapi.storage.DataManager;
import xyz.srnyx.manymobs.libs.annoyingapi.storage.FailedSet;
import xyz.srnyx.manymobs.libs.annoyingapi.storage.Value;
import xyz.srnyx.manymobs.libs.annoyingapi.storage.dialects.Dialect;

public abstract class SQLDialect
extends Dialect {
    @NotNull
    public final Connection connection;
    @NotNull
    public final ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Value>>> cache = new ConcurrentHashMap();

    public SQLDialect(@NotNull DataManager dataManager) throws ConnectionException {
        super(dataManager);
        this.connection = dataManager.storageConfig.createConnection();
    }

    @Override
    @Nullable
    public Value getFromCacheImpl(@NotNull String table, @NotNull String target, @NotNull String key) {
        ConcurrentHashMap<String, ConcurrentHashMap<String, Value>> tableMap = this.cache.get(table);
        if (tableMap == null) {
            return null;
        }
        Map targetMap = tableMap.get(target);
        return targetMap == null ? null : (Value)targetMap.get(key);
    }

    @Override
    public void setToCacheImpl(@NotNull String table, @NotNull String target, @NotNull String key, @NotNull Value value) {
        this.cache.computeIfAbsent(table, k -> new ConcurrentHashMap()).computeIfAbsent(target, k -> new ConcurrentHashMap()).put(key, value);
    }

    @Override
    public void markRemovedInCacheImpl(@NotNull String table, @NotNull String target, @NotNull String key) {
        this.cache.computeIfAbsent(table, k -> new ConcurrentHashMap()).computeIfAbsent(target, k -> new ConcurrentHashMap()).put(key, new Value());
    }

    @Override
    public void saveCacheImpl() {
        for (FailedSet failure : this.setToDatabase(this.cache)) {
            AnnoyingPlugin.log(Level.SEVERE, "&cFailed to save cached &4" + failure.column + "&c for &4" + failure.target + "&c in table &4" + failure.table + "&c: &4" + failure.value, failure.exception);
        }
    }

    @Override
    public void saveCacheImpl(@NotNull String table, @NotNull String target) {
        Map tableMap = this.cache.get(table);
        if (tableMap == null) {
            return;
        }
        ConcurrentHashMap targetMap = (ConcurrentHashMap)tableMap.get(target);
        if (targetMap != null) {
            for (FailedSet failure : this.setToDatabase(table, target, targetMap)) {
                AnnoyingPlugin.log(Level.SEVERE, "&cFailed to save cached &4" + failure.column + "&c for &4" + failure.target + "&c in table &4" + failure.table + "&c: &4" + failure.value, failure.exception);
            }
        }
    }

    @Override
    @NotNull
    public Optional<Dialect.MigrationData> getMigrationDataFromDatabaseImpl(@NotNull DataManager newManager) {
        HashSet<String> tables = new HashSet<String>();
        try (PreparedStatement getTables = this.getTables();){
            ResultSet resultSet = getTables.executeQuery();
            while (resultSet.next()) {
                tables.add(resultSet.getString(1));
            }
        }
        catch (SQLException e) {
            AnnoyingPlugin.log(Level.SEVERE, this.dataManager.storageConfig.migrationLogPrefix + "Failed to get tables!", e);
            return Optional.empty();
        }
        HashMap<String, Set<String>> tablesKeys = new HashMap<String, Set<String>>();
        ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Value>>> values = new ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Value>>>();
        int oldPrefixLength = this.dataManager.tablePrefix.length();
        for (String table : tables) {
            String tableWithoutPrefix = table.substring(oldPrefixLength);
            ConcurrentHashMap tableValues = new ConcurrentHashMap();
            try {
                PreparedStatement getValues = this.getAllValuesFromDatabase(table);
                try {
                    ResultSet resultSet = getValues.executeQuery();
                    HashSet<String> keys = new HashSet<String>();
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    int keyCount = metaData.getColumnCount();
                    if (keyCount == 0) {
                        AnnoyingPlugin.log(Level.WARNING, this.dataManager.storageConfig.migrationLogPrefix + "Table &4" + table + "&c has no keys, skipping...");
                        continue;
                    }
                    for (int i = 1; i <= keyCount; ++i) {
                        keys.add(metaData.getColumnName(i));
                    }
                    if (!keys.contains("target")) {
                        AnnoyingPlugin.log(Level.WARNING, this.dataManager.storageConfig.migrationLogPrefix + "Table &4" + table + "&c doesn't have a '&4target&c' key, skipping...");
                        continue;
                    }
                    tablesKeys.put(tableWithoutPrefix, keys);
                    while (resultSet.next()) {
                        String target = resultSet.getString("target");
                        if (target == null) continue;
                        ConcurrentHashMap<String, Value> keyValues = new ConcurrentHashMap<String, Value>();
                        for (String key : keys) {
                            if (key.equals("target")) continue;
                            keyValues.put(key, new Value(resultSet.getString(key)));
                        }
                        tableValues.put(target, keyValues);
                    }
                }
                finally {
                    if (getValues == null) continue;
                    getValues.close();
                    continue;
                }
            }
            catch (SQLException e) {
                AnnoyingPlugin.log(Level.SEVERE, this.dataManager.storageConfig.migrationLogPrefix + "Failed to get values for table &4" + table, e);
            }
            if (tableValues.isEmpty()) continue;
            values.put(newManager.getTableName(tableWithoutPrefix), tableValues);
        }
        return Optional.of(new Dialect.MigrationData(tablesKeys, values));
    }

    public void createTablesKeys(@NotNull Map<String, Set<String>> tablesKeys) {
        for (Map.Entry<String, Set<String>> entry : tablesKeys.entrySet()) {
            String table = this.dataManager.getTableName(entry.getKey());
            try (PreparedStatement statement = this.createTable(table);){
                statement.executeUpdate();
            }
            catch (SQLException e) {
                AnnoyingPlugin.log(Level.SEVERE, "&cFailed to create table &4" + table, e);
                continue;
            }
            for (String key : entry.getValue()) {
                String keyLower = key.toLowerCase();
                if (keyLower.equals("target")) continue;
                try {
                    PreparedStatement keyStatement = this.createKeyImpl(table, keyLower);
                    try {
                        if (keyStatement == null) continue;
                        keyStatement.executeUpdate();
                    }
                    finally {
                        if (keyStatement == null) continue;
                        keyStatement.close();
                    }
                }
                catch (SQLException e) {
                    AnnoyingPlugin.log(Level.SEVERE, "&cFailed to create key &4" + keyLower + "&c in table &4" + table, e);
                }
            }
        }
    }

    @NotNull
    protected PreparedStatement setValuesParameters(@NotNull String target, @NotNull List<Value> values, @NotNull StringBuilder insertBuilder, @NotNull StringBuilder valuesBuilder, @Nullable StringBuilder updateBuilder) throws SQLException {
        boolean hasUpdate = updateBuilder != null;
        StringBuilder query = insertBuilder.append((CharSequence)valuesBuilder);
        if (hasUpdate) {
            query.append((CharSequence)updateBuilder);
        }
        PreparedStatement statement = this.connection.prepareStatement(query.toString());
        statement.setString(1, target);
        int i = this.setValuesParameters(statement, values, 2);
        if (hasUpdate) {
            this.setValuesParameters(statement, values, i);
        }
        return statement;
    }

    private int setValuesParameters(@NotNull PreparedStatement statement, @NotNull List<Value> values, int i) throws SQLException {
        for (Value value : values) {
            if (value.value == null) {
                statement.setNull(i++, 12);
                continue;
            }
            statement.setString(i++, value.value);
        }
        return i;
    }

    @NotNull
    public final PreparedStatement getTables() throws SQLException {
        return this.getTablesImpl();
    }

    @NotNull
    public final PreparedStatement createTable(@NotNull String table) throws SQLException {
        return this.createTableImpl(table);
    }

    @Nullable
    public final PreparedStatement createKey(@NotNull String table, @NotNull String key) throws SQLException {
        return this.createKeyImpl(table, key.toLowerCase());
    }

    @NotNull
    public final PreparedStatement getAllValuesFromDatabase(@NotNull String table) throws SQLException {
        return this.getAllValuesFromDatabaseImpl(table);
    }

    @NotNull
    protected abstract PreparedStatement getTablesImpl() throws SQLException;

    @NotNull
    protected abstract PreparedStatement createTableImpl(@NotNull String var1) throws SQLException;

    @Nullable
    protected abstract PreparedStatement createKeyImpl(@NotNull String var1, @NotNull String var2) throws SQLException;

    @NotNull
    protected abstract PreparedStatement getAllValuesFromDatabaseImpl(@NotNull String var1) throws SQLException;
}

