/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.callback_dispatcher;

import it.unimi.dsi.fastutil.longs.Long2ReferenceArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import me.decce.ixeris.core.glfw.callback_dispatcher.CommonCallbacks;
import me.decce.ixeris.core.threading.RenderThreadDispatcher;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.system.Callback;

public class FramebufferSizeCallbackDispatcher {
    private static final Long2ReferenceMap<FramebufferSizeCallbackDispatcher> instance = new Long2ReferenceArrayMap(1);
    private final ReferenceArrayList<GLFWFramebufferSizeCallbackI> mainThreadCallbacks = new ReferenceArrayList(1);
    private boolean lastCallbackSet;
    public GLFWFramebufferSizeCallbackI lastCallback;
    public long lastCallbackAddress;
    private final long window;
    public volatile boolean suppressChecks;

    private FramebufferSizeCallbackDispatcher(long window) {
        this.window = window;
    }

    public static synchronized FramebufferSizeCallbackDispatcher get(long window) {
        if (!instance.containsKey(window)) {
            instance.put(window, (Object)new FramebufferSizeCallbackDispatcher(window));
            ((FramebufferSizeCallbackDispatcher)instance.get(window)).validate();
        }
        return (FramebufferSizeCallbackDispatcher)instance.get(window);
    }

    public synchronized void registerMainThreadCallback(GLFWFramebufferSizeCallbackI callback) {
        this.mainThreadCallbacks.add((Object)callback);
        this.validate();
    }

    public synchronized long update(long newAddress) {
        this.suppressChecks = true;
        long ret = this.lastCallbackAddress;
        if (newAddress == 0L && this.mainThreadCallbacks.isEmpty()) {
            GLFW.nglfwSetFramebufferSizeCallback((long)this.window, (long)0L);
        } else {
            GLFW.nglfwSetFramebufferSizeCallback((long)this.window, (long)CommonCallbacks.framebufferSizeCallback.address());
        }
        this.lastCallbackAddress = newAddress;
        if (!this.lastCallbackSet) {
            this.lastCallback = newAddress == 0L ? null : (GLFWFramebufferSizeCallbackI)Callback.get((long)newAddress);
        }
        this.lastCallbackSet = false;
        this.suppressChecks = false;
        return ret;
    }

    public synchronized void update(GLFWFramebufferSizeCallbackI callback) {
        this.lastCallback = callback;
        this.lastCallbackSet = true;
    }

    public synchronized void validate() {
        this.suppressChecks = true;
        long current = GLFW.nglfwSetFramebufferSizeCallback((long)this.window, (long)CommonCallbacks.framebufferSizeCallback.address());
        if (current == 0L) {
            if (this.mainThreadCallbacks.isEmpty()) {
                GLFW.nglfwSetFramebufferSizeCallback((long)this.window, (long)0L);
            }
        } else if (current != CommonCallbacks.framebufferSizeCallback.address()) {
            this.lastCallback = (GLFWFramebufferSizeCallbackI)Callback.get((long)current);
            this.lastCallbackAddress = current;
        }
        this.suppressChecks = false;
    }

    public void onCallback(long window, int width, int height) {
        if (this.window != window) {
            return;
        }
        for (int i = 0; i < this.mainThreadCallbacks.size(); ++i) {
            ((GLFWFramebufferSizeCallbackI)this.mainThreadCallbacks.get(i)).invoke(window, width, height);
        }
        if (this.lastCallback != null) {
            RenderThreadDispatcher.runLater(() -> {
                if (this.lastCallback != null) {
                    this.lastCallback.invoke(window, width, height);
                }
            });
        }
    }

    @FunctionalInterface
    public static interface DispatchedRunnable
    extends Runnable {
    }
}

