/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.mixins;

import me.decce.ixeris.VersionCompatUtils;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.threading.MainThreadDispatcher;
import me.decce.ixeris.core.threading.RenderThreadDispatcher;
import me.decce.ixeris.core.util.PlatformHelper;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.CGL;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class}, priority=500)
public abstract class MinecraftMixin {
    @Inject(method={"runTick"}, at={@At(value="HEAD")})
    private void ixeris$pollEvents(boolean tick, CallbackInfo ci) {
        MainThreadDispatcher.requestPollEvents();
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Ljava/lang/Thread;yield()V", shift=At.Shift.AFTER)})
    private void ixeris$replayQueue(boolean tick, CallbackInfo ci) {
        VersionCompatUtils.profilerPopPush("callback");
        RenderThreadDispatcher.replayQueue();
    }

    @Inject(method={"destroy"}, at={@At(value="INVOKE", target="Ljava/lang/System;exit(I)V")})
    private void ixeris$destroy(CallbackInfo ci) {
        Ixeris.shouldExit = true;
        if (!Ixeris.getConfig().isFullyBlockingMode()) {
            try {
                Ixeris.mainThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Inject(method={"runTick"}, at={@At(value="CONSTANT", args={"stringValue=Render"})})
    private void ixeris$beforeRender(CallbackInfo ci) {
        if (PlatformHelper.isMacOs()) {
            long context = CGL.CGLGetCurrentContext();
            CGL.CGLLockContext((long)context);
        }
    }

    @Inject(method={"runTick"}, at={@At(value="CONSTANT", args={"stringValue=Post render"})})
    private void ixeris$afterRender(CallbackInfo ci) {
        if (PlatformHelper.isMacOs()) {
            long context = CGL.CGLGetCurrentContext();
            CGL.CGLUnlockContext((long)context);
        }
    }
}

