/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.classtransform.mappings.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;
import me.decce.ixeris.core.shadow.classtransform.mappings.AMapper;
import me.decce.ixeris.core.shadow.classtransform.mappings.MapperConfig;
import me.decce.ixeris.core.shadow.classtransform.utils.IOSupplier;
import me.decce.ixeris.core.shadow.classtransform.utils.mappings.MapRemapper;

@ParametersAreNonnullByDefault
public class TinyV1Mapper
extends AMapper {
    private final IOSupplier<InputStream> mappingsSupplier;
    private final String from;
    private final String to;

    public TinyV1Mapper(MapperConfig config, @WillClose InputStream mappingsStream, String from, String to) {
        super(config);
        this.mappingsSupplier = () -> mappingsStream;
        this.from = from;
        this.to = to;
    }

    public TinyV1Mapper(MapperConfig config, File mappingsFile, String from, String to) {
        super(config);
        this.mappingsSupplier = () -> new FileInputStream(mappingsFile);
        this.from = from;
        this.to = to;
    }

    @Override
    protected void init() throws Throwable {
        MapRemapper descriptorRemapper = new MapRemapper();
        ArrayList<TempMapping> tempMappings = new ArrayList<TempMapping>();
        List<String> lines = this.readLines(this.mappingsSupplier.get());
        int fromIndex = -1;
        int toIndex = -1;
        for (String line : lines) {
            String descriptor;
            String toName;
            String fromName;
            if (line.trim().isEmpty()) continue;
            String[] parts = line.trim().split("\t+");
            if (fromIndex == -1) {
                this.verifyHeader(parts);
                String[] mappingNames = Arrays.copyOfRange(parts, 1, parts.length);
                List<String> mappingNamesList = Arrays.asList(mappingNames);
                fromIndex = mappingNamesList.indexOf(this.from);
                toIndex = mappingNamesList.indexOf(this.to);
                if (fromIndex == -1) {
                    throw new IllegalArgumentException("Unable to find from mapping '" + this.from + "'");
                }
                if (toIndex != -1) continue;
                throw new IllegalArgumentException("Unable to find to mapping '" + this.to + "'");
            }
            if (line.startsWith("CLASS\t")) {
                String baseName = parts[1];
                fromName = parts[1 + fromIndex];
                toName = parts[1 + toIndex];
                descriptorRemapper.addClassMapping(baseName, fromName);
                this.remapper.addClassMapping(fromName, toName);
                continue;
            }
            if (line.startsWith("FIELD")) {
                descriptor = parts[2];
                fromName = parts[3 + fromIndex];
                toName = parts[3 + toIndex];
                tempMappings.add(new TempMapping(false, parts[1], fromName, descriptor, toName));
                continue;
            }
            if (line.startsWith("METHOD")) {
                descriptor = parts[2];
                fromName = parts[3 + fromIndex];
                toName = parts[3 + toIndex];
                tempMappings.add(new TempMapping(true, parts[1], fromName, descriptor, toName));
                continue;
            }
            throw new IllegalStateException("Unknown line: " + line);
        }
        for (TempMapping tempMapping : tempMappings) {
            if (tempMapping.method) {
                this.remapper.addMethodMapping(descriptorRemapper.mapSafe(tempMapping.owner), tempMapping.name, descriptorRemapper.mapMethodDesc(tempMapping.descriptor), tempMapping.newName);
                continue;
            }
            this.remapper.addFieldMapping(descriptorRemapper.mapSafe(tempMapping.owner), tempMapping.name, descriptorRemapper.mapDesc(tempMapping.descriptor), tempMapping.newName);
        }
    }

    private void verifyHeader(String[] parts) {
        if (!parts[0].equals("v1")) {
            throw new IllegalStateException("Invalid tiny header (magic)");
        }
        if (parts.length < 3) {
            throw new IllegalStateException("Invalid tiny header (missing columns)");
        }
    }

    private static class TempMapping {
        private final boolean method;
        private final String owner;
        private final String name;
        private final String descriptor;
        private final String newName;

        private TempMapping(boolean method, String owner, String name, String descriptor, String newName) {
            this.method = method;
            this.owner = owner;
            this.name = name;
            this.descriptor = descriptor;
            this.newName = newName;
        }
    }
}

