/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.callback_dispatcher;

import it.unimi.dsi.fastutil.longs.Long2ReferenceArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import me.decce.ixeris.core.glfw.callback_dispatcher.CommonCallbacks;
import me.decce.ixeris.core.threading.RenderThreadDispatcher;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.system.Callback;

public class WindowFocusCallbackDispatcher {
    private static final Long2ReferenceMap<WindowFocusCallbackDispatcher> instance = new Long2ReferenceArrayMap(1);
    private final ReferenceArrayList<GLFWWindowFocusCallbackI> mainThreadCallbacks = new ReferenceArrayList(1);
    private boolean lastCallbackSet;
    public GLFWWindowFocusCallbackI lastCallback;
    public long lastCallbackAddress;
    private final long window;
    public volatile boolean suppressChecks;

    private WindowFocusCallbackDispatcher(long window) {
        this.window = window;
    }

    public static synchronized WindowFocusCallbackDispatcher get(long window) {
        if (!instance.containsKey(window)) {
            instance.put(window, (Object)new WindowFocusCallbackDispatcher(window));
            ((WindowFocusCallbackDispatcher)instance.get(window)).validate();
        }
        return (WindowFocusCallbackDispatcher)instance.get(window);
    }

    public synchronized void registerMainThreadCallback(GLFWWindowFocusCallbackI callback) {
        this.mainThreadCallbacks.add((Object)callback);
        this.validate();
    }

    public synchronized long update(long newAddress) {
        this.suppressChecks = true;
        long ret = this.lastCallbackAddress;
        if (newAddress == 0L && this.mainThreadCallbacks.isEmpty()) {
            GLFW.nglfwSetWindowFocusCallback((long)this.window, (long)0L);
        } else {
            GLFW.nglfwSetWindowFocusCallback((long)this.window, (long)CommonCallbacks.windowFocusCallback.address());
        }
        this.lastCallbackAddress = newAddress;
        if (!this.lastCallbackSet) {
            this.lastCallback = newAddress == 0L ? null : (GLFWWindowFocusCallbackI)Callback.get((long)newAddress);
        }
        this.lastCallbackSet = false;
        this.suppressChecks = false;
        return ret;
    }

    public synchronized void update(GLFWWindowFocusCallbackI callback) {
        this.lastCallback = callback;
        this.lastCallbackSet = true;
    }

    public synchronized void validate() {
        this.suppressChecks = true;
        long current = GLFW.nglfwSetWindowFocusCallback((long)this.window, (long)CommonCallbacks.windowFocusCallback.address());
        if (current == 0L) {
            if (this.mainThreadCallbacks.isEmpty()) {
                GLFW.nglfwSetWindowFocusCallback((long)this.window, (long)0L);
            }
        } else if (current != CommonCallbacks.windowFocusCallback.address()) {
            this.lastCallback = (GLFWWindowFocusCallbackI)Callback.get((long)current);
            this.lastCallbackAddress = current;
        }
        this.suppressChecks = false;
    }

    public void onCallback(long window, boolean focused) {
        if (this.window != window) {
            return;
        }
        for (int i = 0; i < this.mainThreadCallbacks.size(); ++i) {
            ((GLFWWindowFocusCallbackI)this.mainThreadCallbacks.get(i)).invoke(window, focused);
        }
        if (this.lastCallback != null) {
            RenderThreadDispatcher.runLater(() -> {
                if (this.lastCallback != null) {
                    this.lastCallback.invoke(window, focused);
                }
            });
        }
    }

    @FunctionalInterface
    public static interface DispatchedRunnable
    extends Runnable {
    }
}

