/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.state_caching.global;

import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMaps;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.glfw.state_caching.global.GlfwGlobalCache;
import me.decce.ixeris.core.glfw.state_caching.util.KeyNameHelper;
import me.decce.ixeris.core.threading.MainThreadDispatcher;
import org.lwjgl.glfw.GLFW;

public class GlfwKeyNameCache
extends GlfwGlobalCache {
    private final AtomicReferenceArray<String> keyToName = new AtomicReferenceArray(349);
    private final Int2ReferenceMap<String> scancodeToName = Int2ReferenceMaps.synchronize((Int2ReferenceMap)new Int2ReferenceOpenHashMap());

    public GlfwKeyNameCache() {
        this.enableCache();
    }

    public String get(int key, int scancode) {
        String ret;
        if (key == -1) {
            ret = (String)this.scancodeToName.get(scancode);
            if (ret == null) {
                ret = this.blockingGet(key, scancode);
                this.scancodeToName.put(scancode, (Object)ret);
            } else {
                this.updateLater(key, scancode);
            }
        } else {
            if (key < 32 || key > 348) {
                if (Ixeris.getConfig().shouldLogCacheIssues()) {
                    Ixeris.LOGGER.warn("A call to glfwGetKeyName was made with illegal arguments: key {}, scancode {}", (Object)key, (Object)scancode);
                    Thread.dumpStack();
                }
                return this.blockingGet(key, scancode);
            }
            if (!KeyNameHelper.isPrintable(key)) {
                return null;
            }
            ret = this.keyToName.get(key);
            if (ret == null) {
                ret = this.blockingGet(key, scancode);
                this.keyToName.set(key, ret);
            } else {
                this.updateLater(key, scancode);
            }
        }
        return ret;
    }

    private String blockingGet(int key, int scancode) {
        this.disableCache();
        String ret = GLFW.glfwGetKeyName((int)key, (int)scancode);
        this.enableCache();
        return ret;
    }

    public void setKey(int key, String name) {
        this.keyToName.set(key, name);
    }

    public void setScancode(int scancode, String name) {
        this.scancodeToName.put(scancode, (Object)name);
    }

    private void updateLater(int key, int scancode) {
        MainThreadDispatcher.runLater(() -> {
            this.disableCache();
            String name = GLFW.glfwGetKeyName((int)key, (int)scancode);
            this.enableCache();
            if (key == -1) {
                this.setKey(key, name);
            } else {
                this.setScancode(scancode, name);
            }
        });
    }
}

