/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.classtransform.transformer.impl;

import java.lang.reflect.Modifier;
import javax.annotation.ParametersAreNonnullByDefault;
import me.decce.ixeris.core.shadow.classtransform.TransformerManager;
import me.decce.ixeris.core.shadow.classtransform.annotations.injection.COverride;
import me.decce.ixeris.core.shadow.classtransform.exceptions.TransformerException;
import me.decce.ixeris.core.shadow.classtransform.transformer.types.RemovingTargetAnnotationHandler;
import me.decce.ixeris.core.shadow.classtransform.utils.ASMUtils;
import me.decce.ixeris.core.shadow.classtransform.utils.Types;
import me.decce.ixeris.core.shadow.classtransform.utils.mappings.Remapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
public class COverrideAnnotationHandler
extends RemovingTargetAnnotationHandler<COverride> {
    public COverrideAnnotationHandler() {
        super(COverride.class, COverride::value);
    }

    @Override
    public void transform(COverride annotation, TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod, MethodNode target) {
        if (Modifier.isStatic(target.access) != Modifier.isStatic(transformerMethod.access)) {
            throw TransformerException.wrongStaticAccess(transformerMethod, transformer, Modifier.isStatic(target.access));
        }
        if (!ASMUtils.compareTypes(Types.argumentTypes(target.desc), Types.argumentTypes(transformerMethod.desc))) {
            throw TransformerException.wrongArguments(transformerMethod, transformer, Types.argumentTypes(target.desc));
        }
        if (ASMUtils.isAccessLower(transformerMethod.access, target.access)) {
            throw new TransformerException(transformerMethod, transformer, "must have higher/equal access than original method");
        }
        transformerMethod.name = target.name;
        transformerMethod.desc = target.desc;
        transformedClass.methods.remove(target);
        this.prepareForCopy(transformer, transformerMethod);
        Remapper.remapAndAdd(transformer, transformedClass, transformerMethod);
    }
}

