/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris;

import com.mojang.blaze3d.systems.RenderSystem;
import me.decce.ixeris.workarounds.WindowMinimizedStateWorkaround;
import net.minecraft.client.GameConfiguration;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.util.UndeclaredException;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.Util;
import org.apache.logging.log4j.Logger;

public class VersionCompatUtils {
    public static void initGameThread() {
        RenderSystem.initGameThread((boolean)false);
    }

    public static void beginInitialization() {
    }

    public static void finishInitialization() {
    }

    public static Minecraft tryCreateMinecraft(GameConfiguration gameConfig, Logger logger) {
        Minecraft minecraft = null;
        try {
            RenderSystem.initRenderThread();
            VersionCompatUtils.beginInitialization();
            minecraft = new Minecraft(gameConfig);
            VersionCompatUtils.finishInitialization();
            WindowMinimizedStateWorkaround.init();
        }
        catch (UndeclaredException silentInitException) {
            Util.func_240993_h_();
            logger.warn("Failed to create window: ", (Throwable)silentInitException);
            return null;
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)"Initializing game");
            crashReport.func_85058_a("Initialization");
            Minecraft.func_228009_a_((LanguageManager)null, (String)gameConfig.field_178741_d.field_178755_b, (GameSettings)null, (CrashReport)crashReport);
            Minecraft.func_71377_b((CrashReport)crashReport);
            return null;
        }
        return minecraft;
    }

    public static void profilerPush(String str) {
        Minecraft.func_71410_x().func_213239_aq().func_76320_a(str);
    }

    public static void profilerPop() {
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }

    public static void profilerPopPush(String str) {
        VersionCompatUtils.profilerPop();
        VersionCompatUtils.profilerPush(str);
    }

    public static long getMinecraftWindow() {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        if (window == null) {
            return 0L;
        }
        return window.func_198092_i();
    }
}

