/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.state_caching.global;

import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import me.decce.ixeris.core.glfw.state_caching.global.GlfwCachedStandardCursor;
import me.decce.ixeris.core.glfw.state_caching.global.GlfwGlobalCache;
import org.lwjgl.glfw.GLFW;

public class GlfwStandardCursorCache
extends GlfwGlobalCache {
    private final Int2ReferenceOpenHashMap<GlfwCachedStandardCursor> shapes = new Int2ReferenceOpenHashMap();
    private final Long2ReferenceOpenHashMap<GlfwCachedStandardCursor> cursors = new Long2ReferenceOpenHashMap();

    public GlfwStandardCursorCache() {
        this.enableCache();
    }

    public long create(int shape) {
        GlfwCachedStandardCursor cache = (GlfwCachedStandardCursor)this.shapes.get(shape);
        if (cache == null) {
            cache = this.blockingCreate(shape);
        } else {
            this.disableCache();
            cache.recreate(this.cursors);
            this.enableCache();
        }
        return cache == null ? 0L : cache.cursor();
    }

    public boolean isCached(long cursor) {
        return this.cursors.containsKey(cursor);
    }

    public void destroy(long cursor) {
        GlfwCachedStandardCursor cache = (GlfwCachedStandardCursor)this.cursors.get(cursor);
        if (cache != null && cache.cursor() == cursor) {
            this.disableCache();
            cache.dispose();
            this.enableCache();
        }
    }

    private GlfwCachedStandardCursor blockingCreate(int shape) {
        this.disableCache();
        long cursor = GLFW.glfwCreateStandardCursor((int)shape);
        this.enableCache();
        if (cursor != 0L) {
            GlfwCachedStandardCursor ret = new GlfwCachedStandardCursor(shape, cursor);
            this.shapes.put(shape, (Object)ret);
            this.cursors.put(cursor, (Object)ret);
            return ret;
        }
        return null;
    }
}

