/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.forge;

import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Objects;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.shadow.classtransform.transformer.IAnnotationHandlerPreprocessor;
import me.decce.ixeris.core.shadow.reflect.Agents;
import me.decce.ixeris.forge.LegacyForgeClassLoaderHandler;
import me.decce.ixeris.forge.LegacyForgeTransformationHelper;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;

public class IxerisTransformer {
    private final Logger LOGGER = LogManager.getLogger();

    public void run() {
        if (!IxerisTransformer.isOnClient()) {
            this.LOGGER.info("Skipped Ixeris bootstrapping because: on dedicated server");
            return;
        }
        LegacyForgeClassLoaderHandler classLoaderHandler = new LegacyForgeClassLoaderHandler(Logger.class.getClassLoader(), this.getClass().getClassLoader());
        classLoaderHandler.loadCoreClasses(this.getClass());
        classLoaderHandler.removeModClassesFromServiceLayer();
        if (!Ixeris.getConfig().isEnabled()) {
            this.LOGGER.info("Skipped Ixeris bootstrapping because: disabled by config");
            return;
        }
        this.LOGGER.info("Attempting to transform org.lwjgl.glfw.GLFW");
        LegacyForgeTransformationHelper helper = new LegacyForgeTransformationHelper(classLoaderHandler.modClassLoader);
        helper.expandGlfwModuleReads();
        byte[] bytes = helper.doTransformation("org.lwjgl.glfw.GLFW", classLoaderHandler.readClassBytes("org/lwjgl/glfw/GLFW.class"), false, new IAnnotationHandlerPreprocessor[0]);
        try {
            this.redefineGlfw(bytes);
        }
        catch (ClassNotFoundException | UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
        Ixeris.inEarlyDisplay = true;
        try {
            classLoaderHandler.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Instrumentation getInstrumentation() {
        try {
            return Objects.requireNonNull(Agents.getInstrumentation());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void redefineGlfw(byte[] bytes) throws UnmodifiableClassException, ClassNotFoundException {
        Instrumentation instrumentation = this.getInstrumentation();
        instrumentation.redefineClasses(new ClassDefinition(GLFW.class, bytes));
    }

    public static boolean isOnClient() {
        return FMLLoader.getDist().isClient();
    }
}

