/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.forge;

import cpw.mods.modlauncher.TransformingClassLoader;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import me.decce.ixeris.core.transform.ClassLoaderHandler;
import net.minecraftforge.fml.loading.FMLLoader;

public class LegacyForgeClassLoaderHandler
extends ClassLoaderHandler {
    public static final String LEGACY_FORGE_MOD_CLASSLOADER = "cpw.mods.modlauncher.TransformingClassLoader";
    private FileSystem fileSystem;

    public LegacyForgeClassLoaderHandler(ClassLoader bootstrapClassLoader, ClassLoader modClassLoader) {
        super(bootstrapClassLoader, modClassLoader);
    }

    @Override
    public void verifyClassLoaders() {
        if (!LEGACY_FORGE_MOD_CLASSLOADER.equals(this.modClassLoader.getClass().getName())) {
            super.verifyClassLoaders();
        }
    }

    @Override
    public void removeModClassesFromServiceLayer() {
        ((TransformingClassLoader)this.modClassLoader).addTargetPackageFilter(s -> !s.startsWith("me.decce.ixeris.core"));
    }

    @Override
    protected Stream<Path> getClassesStream(Class<?> modClass) {
        Path path = FMLLoader.getLoadingModList().getModFileById("ixeris").getFile().getFilePath();
        try {
            this.fileSystem = FileSystems.newFileSystem(path);
            return Files.walk(this.fileSystem.getPath("/me/decce/ixeris/core", new String[0]), new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.close();
        }
    }
}

