/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.shadow.mixinextras.expression.impl.ast.expressions;

import me.decce.ixeris.shadow.mixinextras.expression.impl.ExpressionSource;
import me.decce.ixeris.shadow.mixinextras.expression.impl.ast.expressions.SimpleExpression;
import me.decce.ixeris.shadow.mixinextras.expression.impl.flow.FlowValue;
import me.decce.ixeris.shadow.mixinextras.expression.impl.point.ExpressionContext;
import me.decce.ixeris.shadow.mixinextras.expression.impl.utils.ExpressionASMUtils;
import org.objectweb.asm.Type;

public class StringLiteralExpression
extends SimpleExpression {
    public final String value;
    private final Integer charValue;

    public StringLiteralExpression(ExpressionSource src, String value) {
        super(src);
        this.value = value;
        this.charValue = value.length() == 1 ? Integer.valueOf(value.charAt(0)) : null;
    }

    @Override
    protected boolean matchesImpl(FlowValue node, ExpressionContext ctx) {
        Object cst = ExpressionASMUtils.getConstant(node.getInsn());
        if (cst == null) {
            return false;
        }
        return cst.equals(this.value) || node.typeMatches(Type.CHAR_TYPE) && cst.equals(this.charValue);
    }
}

