/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.shadow.mixinextras.sugar.impl.handlers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import me.decce.ixeris.shadow.mixinextras.injector.wrapoperation.WrapOperation;
import me.decce.ixeris.shadow.mixinextras.service.MixinExtrasService;
import me.decce.ixeris.shadow.mixinextras.sugar.impl.SugarParameter;
import me.decce.ixeris.shadow.mixinextras.sugar.impl.handlers.HandlerInfo;
import me.decce.ixeris.shadow.mixinextras.sugar.impl.handlers.HandlerTransformer;
import me.decce.ixeris.shadow.mixinextras.sugar.impl.ref.LocalRefUtils;
import me.decce.ixeris.shadow.mixinextras.utils.ASMUtils;
import me.decce.ixeris.shadow.mixinextras.wrapper.factory.FactoryRedirectWrapper;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;

class LocalHandlerTransformer
extends HandlerTransformer {
    private static final Set<String> TARGET_INJECTORS = new HashSet<String>(Arrays.asList(Type.getDescriptor(ModifyConstant.class), Type.getDescriptor(Redirect.class), Type.getDescriptor(FactoryRedirectWrapper.class)));

    LocalHandlerTransformer(IMixinInfo mixin, SugarParameter parameter) {
        super(mixin, parameter);
    }

    @Override
    public boolean isRequired(MethodNode handler) {
        AnnotationNode annotation = InjectionInfo.getInjectorAnnotation((IMixinInfo)this.mixin, (MethodNode)handler);
        return annotation != null && TARGET_INJECTORS.contains(annotation.desc) && LocalRefUtils.getTargetType(this.parameter.type, this.parameter.genericType) == this.parameter.type;
    }

    @Override
    public void transform(HandlerInfo info) {
        Type wrapperType = Type.getType(LocalRefUtils.getInterfaceFor(this.parameter.type));
        info.wrapParameter(this.parameter, wrapperType, ASMUtils.isPrimitive(this.parameter.type) ? null : this.parameter.type, (insns, load) -> LocalRefUtils.generateUnwrapping(insns, this.parameter.type, load));
    }

    static {
        for (String name : MixinExtrasService.getInstance().getAllClassNames(WrapOperation.class.getName())) {
            TARGET_INJECTORS.add('L' + name.replace('.', '/') + ';');
        }
    }
}

