/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.api;

import java.util.function.Supplier;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.threading.MainThreadDispatcher;
import me.decce.ixeris.core.threading.RenderThreadDispatcher;

public class IxerisApi {
    private static final IxerisApi instance = new IxerisApi();

    public static IxerisApi getInstance() {
        return instance;
    }

    public String getMainThreadName() {
        return "Ixeris Event Polling Thread";
    }

    public boolean isEnabled() {
        return Ixeris.getConfig().isEnabled();
    }

    public boolean isInitialized() {
        if (!this.isEnabled()) {
            return false;
        }
        return Ixeris.mainThread != null;
    }

    public boolean isOnMainThreadOrInit() {
        if (!this.isEnabled()) {
            return true;
        }
        return Ixeris.isOnMainThread();
    }

    public boolean isOnMainThread() {
        if (!this.isEnabled()) {
            return true;
        }
        return this.isOnMainThreadOrInit() && this.isInitialized();
    }

    public void runOnMainThread(Runnable runnable) {
        if (this.isEnabled()) {
            MainThreadDispatcher.run(runnable);
        } else {
            runnable.run();
        }
    }

    public void runNowOnMainThread(Runnable runnable) {
        if (this.isEnabled()) {
            MainThreadDispatcher.runNow(runnable);
        } else {
            runnable.run();
        }
    }

    public void runLaterOnMainThread(Runnable runnable) {
        if (this.isEnabled()) {
            MainThreadDispatcher.runLater(runnable);
        } else {
            runnable.run();
        }
    }

    public <T> T query(Supplier<T> supplier) {
        if (this.isEnabled()) {
            return MainThreadDispatcher.query(supplier);
        }
        return supplier.get();
    }

    public void runLaterOnRenderThread(Runnable runnable) {
        if (this.isEnabled()) {
            RenderThreadDispatcher.runLater(runnable);
        } else {
            runnable.run();
        }
    }
}

