/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.neoforge.core;

import java.io.IOException;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.shadow.classtransform.transformer.IAnnotationHandlerPreprocessor;
import me.decce.ixeris.neoforge.core.NeoForgeClassLoaderHandler;
import me.decce.ixeris.neoforge.core.NeoForgeTransformationHelper;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IxerisBootstrapper
implements GraphicsBootstrapper {
    private final Logger LOGGER = LogManager.getLogger();

    public String name() {
        return "ixeris";
    }

    public void bootstrap(String[] arguments) {
        if (!IxerisBootstrapper.isOnClient()) {
            this.LOGGER.info("Skipped Ixeris bootstrapping because: on dedicated server");
            return;
        }
        NeoForgeClassLoaderHandler classLoaderHandler = new NeoForgeClassLoaderHandler(this.getClass().getClassLoader().getParent(), this.getClass().getClassLoader());
        classLoaderHandler.loadCoreClasses(this.getClass());
        classLoaderHandler.removeModClassesFromServiceLayer();
        if (!Ixeris.getConfig().isEnabled()) {
            this.LOGGER.info("Skipped Ixeris bootstrapping because: disabled by config");
            return;
        }
        NeoForgeTransformationHelper helper = new NeoForgeTransformationHelper(classLoaderHandler.modClassLoader);
        this.LOGGER.info("Attempting to transform org.lwjgl.glfw.GLFW");
        helper.expandGlfwModuleReads();
        byte[] transformedBytes = helper.doTransformation("org.lwjgl.glfw.GLFW", classLoaderHandler.readClassBytes("org/lwjgl/glfw/GLFW.class"), true, new IAnnotationHandlerPreprocessor[0]);
        try {
            classLoaderHandler.defineClass(classLoaderHandler.bootstrapClassLoader, "org.lwjgl.glfw.GLFW", transformedBytes);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.temporarilySuppressEventPollingWarning();
        try {
            classLoaderHandler.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void temporarilySuppressEventPollingWarning() {
        Ixeris.suppressEventPollingWarning = true;
    }

    public static boolean isOnClient() {
        return FMLEnvironment.getDist().isClient();
    }
}

