/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.classtransform.exceptions;

import java.util.Collection;
import javax.annotation.ParametersAreNonnullByDefault;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
public class InvalidTargetException
extends RuntimeException {
    private final String memberType;
    private final String memberNameAndDesc;
    private final String transformerName;
    private final String target;
    private final Collection<String> targets;

    public InvalidTargetException(MethodNode method, ClassNode transformer, String target, Collection<String> targets) {
        this.memberType = "Method";
        this.memberNameAndDesc = method.name + method.desc;
        this.transformerName = transformer.name;
        this.target = target;
        this.targets = targets;
    }

    @Override
    public String getMessage() {
        String message = this.memberType + " '" + this.memberNameAndDesc + "' in transformer '" + this.transformerName + "' has invalid target '" + this.target + "'";
        if (!this.targets.isEmpty()) {
            message = message + " (valid targets: ";
            for (String validTarget : this.targets) {
                message = message + validTarget + ", ";
            }
            message = message.substring(0, message.length() - 2);
            message = message + ")";
        }
        return message;
    }
}

