/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.forge.transformers;

import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.shadow.classtransform.InjectionCallback;
import me.decce.ixeris.core.shadow.classtransform.annotations.CInline;
import me.decce.ixeris.core.shadow.classtransform.annotations.CTarget;
import me.decce.ixeris.core.shadow.classtransform.annotations.CTransformer;
import me.decce.ixeris.core.shadow.classtransform.annotations.injection.CInject;
import me.decce.ixeris.core.threading.MainThreadDispatcher;
import me.decce.ixeris.core.threading.RenderThreadDispatcher;
import me.decce.ixeris.core.util.LambdaHelper;
import org.lwjgl.glfw.GLFW;

@CTransformer(value={GLFW.class})
public class GLFWTransformer {
    @CInline
    @CInject(method={"glfwInit"}, target={@CTarget(value="TAIL")})
    private static void ixeris$glfwInit(InjectionCallback cir) {
        Ixeris.glfwInitialized = true;
    }

    @CInline
    @CInject(method={"glfwTerminate"}, target={@CTarget(value="TAIL")})
    private static void ixeris$glfwTerminate(InjectionCallback ci) {
        Ixeris.glfwInitialized = false;
    }

    @CInline
    @CInject(method={"glfwPollEvents", "glfwWaitEvents", "glfwWaitEventsTimeout"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$cancelDangerousEventPolling(InjectionCallback ci) {
        if (!Ixeris.isOnMainThread()) {
            ci.setCancelled(true);
            if (!Ixeris.suppressEventPollingWarning) {
                Ixeris.LOGGER.warn("One of the GLFW event polling functions has been called on non-main thread. Consider reporting this to the issue tracker of Ixeris.");
                Thread.dumpStack();
                Ixeris.suppressEventPollingWarning = true;
            }
        }
    }

    @CInline
    @CInject(method={"glfwSetCursorPos"}, target={@CTarget(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwSetCursorPos(long window, double xpos, double ypos, InjectionCallback ci) {
        if (!Ixeris.isOnMainThread()) {
            ci.setCancelled(true);
            MainThreadDispatcher.run(LambdaHelper.makeRunnable(GLFW::glfwSetCursorPos, window, xpos, ypos));
            return;
        }
        if (window == Ixeris.accessor.getMinecraftWindow()) {
            RenderThreadDispatcher.suppressCursorPosCallbacks(true);
            RenderThreadDispatcher.clearQueuedCursorPosCallbacks();
        }
    }

    @CInline
    @CInject(method={"glfwSetCursorPos"}, target={@CTarget(value="TAIL")})
    private static void ixeris$glfwSetCursorPos$tail(long window, double xpos, double ypos, InjectionCallback ci) {
        if (window == Ixeris.accessor.getMinecraftWindow()) {
            Ixeris.accessor.setIgnoreFirstMouseMove();
            RenderThreadDispatcher.suppressCursorPosCallbacks(false);
        }
    }

    @CInline
    @CInject(method={"glfwSetInputMode"}, target={@CTarget(value="TAIL")})
    private static void ixeris$glfwSetInputMode(long window, int mode, int value, InjectionCallback ci) {
        if (window == Ixeris.accessor.getMinecraftWindow() && mode == 208897) {
            if (value == 212993) {
                Ixeris.mouseGrabbed = false;
            } else if (value == 212995) {
                Ixeris.mouseGrabbed = true;
            }
        }
    }
}

