/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import me.decce.ixeris.core.Ixeris;
import org.lwjgl.system.Platform;

public class IxerisConfig {
    private static final Path CONFIG_PATH = Paths.get("config", new String[0]);
    private static final Path FILE = CONFIG_PATH.resolve("ixeris.json");
    private boolean enabledOnWindows = true;
    private boolean enabledOnMacOS = true;
    private boolean enabledOnLinux = true;
    private transient Boolean enabledOnCurrentPlatform;
    private boolean fullyBlockingMode;
    private boolean logBlockingCalls;
    private boolean logCacheIssues;
    @SerializedName(value="greedyEventPolling_v2")
    private boolean greedyEventPolling = true;
    private int eventPollingThreadPriority;

    private IxerisConfig() {
    }

    public boolean isEnabled() {
        if (this.enabledOnCurrentPlatform == null) {
            Platform platform = Platform.get();
            this.enabledOnCurrentPlatform = switch (platform) {
                default -> throw new IncompatibleClassChangeError();
                case Platform.LINUX -> this.enabledOnLinux;
                case Platform.MACOSX -> this.enabledOnMacOS;
                case Platform.WINDOWS -> this.enabledOnWindows;
            };
        }
        return this.enabledOnCurrentPlatform;
    }

    public boolean isFullyBlockingMode() {
        return this.fullyBlockingMode;
    }

    public boolean shouldLogBlockingCalls() {
        return this.logBlockingCalls;
    }

    public boolean shouldLogCacheIssues() {
        return this.logCacheIssues;
    }

    public int getEventPollingThreadPriority() {
        if (this.eventPollingThreadPriority >= 1 && this.eventPollingThreadPriority <= 10) {
            return this.eventPollingThreadPriority;
        }
        return 8;
    }

    public boolean isGreedyEventPolling() {
        return this.greedyEventPolling;
    }

    public long getMainThreadSleepTime() {
        return this.isGreedyEventPolling() ? 4L : 200L;
    }

    public void save() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)this);
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                Files.createDirectory(CONFIG_PATH, new FileAttribute[0]);
            }
            Files.writeString(FILE, (CharSequence)json, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            Ixeris.LOGGER.error("Failed to save configuration!", (Throwable)e);
        }
    }

    public static IxerisConfig load() {
        IxerisConfig config = null;
        if (FILE.toFile().exists()) {
            try {
                config = (IxerisConfig)new Gson().fromJson(Files.readString(FILE), IxerisConfig.class);
            }
            catch (IOException e) {
                Ixeris.LOGGER.error("Failed to read configuration!", (Throwable)e);
            }
        }
        if (config == null) {
            config = new IxerisConfig();
        }
        return config;
    }
}

