/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.callback_dispatcher;

import it.unimi.dsi.fastutil.longs.Long2ReferenceArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.glfw.callback_dispatcher.CommonCallbacks;
import me.decce.ixeris.core.threading.RenderThreadDispatcher;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWWindowPosCallbackI;
import org.lwjgl.system.Callback;

public class WindowPosCallbackDispatcher {
    private static final Long2ReferenceMap<WindowPosCallbackDispatcher> instance = Long2ReferenceMaps.synchronize((Long2ReferenceMap)new Long2ReferenceArrayMap(1));
    private final ReferenceArrayList<GLFWWindowPosCallbackI> mainThreadCallbacks = new ReferenceArrayList(1);
    private boolean lastCallbackSet;
    public GLFWWindowPosCallbackI lastCallback;
    public long lastCallbackAddress;
    private final long window;
    public volatile boolean suppressChecks;

    private WindowPosCallbackDispatcher(long window) {
        this.window = window;
    }

    public static WindowPosCallbackDispatcher get(long window) {
        if (window == Ixeris.accessor.getMinecraftWindow()) {
            return (WindowPosCallbackDispatcher)instance.computeIfAbsent(window, WindowPosCallbackDispatcher::new);
        }
        return (WindowPosCallbackDispatcher)instance.get(window);
    }

    public synchronized void registerMainThreadCallback(GLFWWindowPosCallbackI callback) {
        this.mainThreadCallbacks.add((Object)callback);
        this.validate();
    }

    public synchronized long update(long newAddress) {
        this.suppressChecks = true;
        long ret = this.lastCallbackAddress;
        if (newAddress == 0L && this.mainThreadCallbacks.isEmpty()) {
            GLFW.nglfwSetWindowPosCallback((long)this.window, (long)0L);
        } else {
            GLFW.nglfwSetWindowPosCallback((long)this.window, (long)CommonCallbacks.windowPosCallback.address());
        }
        this.lastCallbackAddress = newAddress;
        if (!this.lastCallbackSet) {
            this.lastCallback = newAddress == 0L ? null : (GLFWWindowPosCallbackI)Callback.get((long)newAddress);
        }
        this.lastCallbackSet = false;
        this.suppressChecks = false;
        return ret;
    }

    public synchronized void update(GLFWWindowPosCallbackI callback) {
        this.lastCallback = callback;
        this.lastCallbackSet = true;
    }

    public synchronized void validate() {
        this.suppressChecks = true;
        long current = GLFW.nglfwSetWindowPosCallback((long)this.window, (long)CommonCallbacks.windowPosCallback.address());
        if (current == 0L) {
            if (this.mainThreadCallbacks.isEmpty()) {
                GLFW.nglfwSetWindowPosCallback((long)this.window, (long)0L);
            }
        } else if (current != CommonCallbacks.windowPosCallback.address()) {
            this.lastCallback = (GLFWWindowPosCallbackI)Callback.get((long)current);
            this.lastCallbackAddress = current;
        }
        this.suppressChecks = false;
    }

    public void onCallback(long window, int xpos, int ypos) {
        if (this.window != window) {
            return;
        }
        for (int i = 0; i < this.mainThreadCallbacks.size(); ++i) {
            ((GLFWWindowPosCallbackI)this.mainThreadCallbacks.get(i)).invoke(window, xpos, ypos);
        }
        if (this.lastCallback != null) {
            RenderThreadDispatcher.runLater(() -> {
                if (this.lastCallback != null) {
                    this.lastCallback.invoke(window, xpos, ypos);
                }
            });
        }
    }

    @FunctionalInterface
    public static interface DispatchedRunnable
    extends Runnable {
    }
}

