/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.state_caching.global;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongLists;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.glfw.callback_dispatcher.MonitorCallbackDispatcher;
import me.decce.ixeris.core.glfw.state_caching.global.GlfwGlobalCache;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;

public class GlfwMonitorCache
extends GlfwGlobalCache {
    private final LongList monitors = LongLists.synchronize((LongList)new LongArrayList());
    private final boolean success = this.initialize();

    public GlfwMonitorCache() {
        MonitorCallbackDispatcher.get().registerMainThreadCallback(this::onMonitorCallback);
        if (this.success) {
            this.enableCache();
        }
    }

    public long getPrimaryMonitor() {
        if (!this.monitors.isEmpty()) {
            return this.monitors.getLong(0);
        }
        return this.blockingGetPrimaryMonitor();
    }

    private long blockingGetPrimaryMonitor() {
        this.disableCache();
        long ret = GLFW.glfwGetPrimaryMonitor();
        this.enableCache();
        return ret;
    }

    private boolean initialize() {
        this.monitors.clear();
        this.disableCache();
        PointerBuffer pointerBuffer = GLFW.glfwGetMonitors();
        this.enableCache();
        if (pointerBuffer != null) {
            for (int i = 0; i < pointerBuffer.limit(); ++i) {
                this.monitors.add(pointerBuffer.get(i));
            }
        }
        if (this.monitors.isEmpty()) {
            Ixeris.LOGGER.warn("Failed to initialize monitor cache! You might experience degraded performance.");
        }
        return !this.monitors.isEmpty();
    }

    private void onMonitorCallback(long monitor, int event) {
        if (this.success) {
            if (event == 262145) {
                this.monitors.add(monitor);
            } else if (event == 262146) {
                this.monitors.removeIf(m -> m == monitor);
            }
        }
    }
}

