/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.reflect.bytecode.impl.asm;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import me.decce.ixeris.core.shadow.reflect.JavaBypass;
import me.decce.ixeris.core.shadow.reflect.bytecode.builder.MethodBuilder;
import me.decce.ixeris.core.shadow.reflect.bytecode.impl.asm.ASMBuilder;
import me.decce.ixeris.core.shadow.reflect.bytecode.wrapper.BytecodeLabel;
import me.decce.ixeris.core.shadow.reflect.bytecode.wrapper.BytecodeType;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class ASMMethodBuilder
implements MethodBuilder {
    private final Object methodVisitor;

    public ASMMethodBuilder(Object methodVisitor) {
        this.methodVisitor = methodVisitor;
    }

    public Object getMethodVisitor() {
        return this.methodVisitor;
    }

    @Override
    public MethodBuilder insn(int opcode) {
        MethodHandle visitInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitInsn", MethodType.methodType(Void.TYPE, Integer.TYPE));
        visitInsn.invoke(this.methodVisitor, opcode);
        return this;
    }

    @Override
    public MethodBuilder int_(int opcode, int value) {
        MethodHandle visitIntInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitIntInsn", MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE));
        visitIntInsn.invoke(this.methodVisitor, opcode, value);
        return this;
    }

    @Override
    public MethodBuilder var(int opcode, int varIndex) {
        MethodHandle visitVarInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitVarInsn", MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE));
        visitVarInsn.invoke(this.methodVisitor, opcode, varIndex);
        return this;
    }

    @Override
    public MethodBuilder type(int opcode, String type) {
        MethodHandle visitTypeInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitTypeInsn", MethodType.methodType(Void.TYPE, Integer.TYPE, String.class));
        visitTypeInsn.invoke(this.methodVisitor, opcode, type);
        return this;
    }

    @Override
    public MethodBuilder field(int opcode, String owner, String name, String descriptor) {
        MethodHandle visitFieldInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitFieldInsn", MethodType.methodType(Void.TYPE, Integer.TYPE, String.class, String.class, String.class));
        visitFieldInsn.invoke(this.methodVisitor, opcode, owner, name, descriptor);
        return this;
    }

    @Override
    public MethodBuilder method(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        MethodHandle visitMethodInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitMethodInsn", MethodType.methodType(Void.TYPE, Integer.TYPE, String.class, String.class, String.class, Boolean.TYPE));
        visitMethodInsn.invoke(this.methodVisitor, opcode, owner, name, descriptor, isInterface);
        return this;
    }

    @Override
    public MethodBuilder jump(int opcode, BytecodeLabel label) {
        MethodHandle visitJumpInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitJumpInsn", MethodType.methodType(Void.TYPE, Integer.TYPE, ASMBuilder.CLASS_Label));
        visitJumpInsn.invoke(this.methodVisitor, opcode, label.getHandle());
        return this;
    }

    @Override
    public MethodBuilder label(BytecodeLabel label) {
        MethodHandle visitLabel = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitLabel", MethodType.methodType(Void.TYPE, ASMBuilder.CLASS_Label));
        visitLabel.invoke(this.methodVisitor, label.getHandle());
        return this;
    }

    @Override
    public MethodBuilder ldc(Object value) {
        if (value instanceof BytecodeType) {
            value = ((BytecodeType)value).getHandle();
        }
        MethodHandle visitLdcInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitLdcInsn", MethodType.methodType(Void.TYPE, Object.class));
        visitLdcInsn.invoke(this.methodVisitor, value);
        return this;
    }

    @Override
    public MethodBuilder iinc(int varIndex, int increment) {
        MethodHandle visitIincInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitIincInsn", MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE));
        visitIincInsn.invoke(this.methodVisitor, varIndex, increment);
        return this;
    }

    @Override
    public MethodBuilder multiANewArray(String descriptor, int dimensions) {
        MethodHandle visitMultiANewArrayInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitMultiANewArrayInsn", MethodType.methodType(Void.TYPE, String.class, Integer.TYPE));
        visitMultiANewArrayInsn.invoke(this.methodVisitor, descriptor, dimensions);
        return this;
    }

    @Override
    public MethodBuilder tryCatch(BytecodeLabel start, BytecodeLabel end, BytecodeLabel handler, String type) {
        MethodHandle visitTryCatchBlock = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitTryCatchBlock", MethodType.methodType(Void.TYPE, ASMBuilder.CLASS_Label, ASMBuilder.CLASS_Label, ASMBuilder.CLASS_Label, String.class));
        visitTryCatchBlock.invoke(this.methodVisitor, start.getHandle(), end.getHandle(), handler.getHandle(), type);
        return this;
    }

    @Override
    public MethodBuilder maxs(int maxStack, int maxLocals) {
        MethodHandle visitMaxs = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitMaxs", MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE));
        visitMaxs.invoke(this.methodVisitor, maxStack, maxLocals);
        return this;
    }
}

