/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.neoforge.core;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.mixins.glfw_state_caching.GLFWMixin;
import me.decce.ixeris.core.shadow.classtransform.transformer.IAnnotationHandlerPreprocessor;
import me.decce.ixeris.core.util.TransformationHelper;
import net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IxerisBootstrapper
implements GraphicsBootstrapper {
    private final Logger LOGGER = LogManager.getLogger();
    private final TransformationHelper helper = new TransformationHelper(Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader());
    private final Class<?>[] TRANSFORMERS = new Class[]{me.decce.ixeris.core.mixins.GLFWMixin.class, me.decce.ixeris.core.mixins.callback_dispatcher.GLFWMixin.class, GLFWMixin.class, me.decce.ixeris.core.mixins.glfw_threading.GLFWMixin.class};

    public String name() {
        return "ixeris";
    }

    public void bootstrap(String[] arguments) {
        if (!IxerisBootstrapper.isOnClient()) {
            this.LOGGER.info("Skipped Ixeris bootstrapping because: on dedicated server");
            return;
        }
        this.helper.verifyClassLoaders();
        this.helper.loadCoreClasses(this.getClass());
        this.LOGGER.info("Attempting to transform org.lwjgl.glfw.GLFW");
        this.helper.expandGlfwModuleReads();
        byte[] transformedBytes = this.helper.doTransformation(this.TRANSFORMERS, true, new IAnnotationHandlerPreprocessor[0]);
        try {
            this.helper.defineClass(this.helper.mcBootstrapClassLoader, "org.lwjgl.glfw.GLFW", transformedBytes);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.helper.removeModClassesFromServiceLayer();
        this.temporarilySuppressEventPollingWarning();
    }

    private void temporarilySuppressEventPollingWarning() {
        Ixeris.suppressEventPollingWarning = true;
    }

    public static boolean isOnClient() {
        ModuleLayer layer = (ModuleLayer)((IModuleLayerManager)Launcher.INSTANCE.findLayerManager().orElseThrow()).getLayer(IModuleLayerManager.Layer.BOOT).orElseThrow();
        return layer.findModule("org.lwjgl.glfw").isPresent();
    }
}

