/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.neoforge.core;

import cpw.mods.jarhandling.JarContents;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IncompatibleFileReporting;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;

public class IxerisModLocator
implements IModFileCandidateLocator {
    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        if (!FMLLoader.getDist().isClient()) {
            return;
        }
        try {
            URL resource = this.getClass().getResource("/META-INF/jarjar/");
            try (Stream<Path> stream = Files.walk(Path.of(Objects.requireNonNull(resource).toURI()), 1, new FileVisitOption[0]);){
                stream.filter(path -> path.getFileName().toString().endsWith("-mod.jar")).forEach(path -> pipeline.addJarContent(JarContents.of((Path)path), ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.ERROR));
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Loading Ixeris JiJ mod", t);
        }
    }
}

