/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.threading;

import com.google.common.collect.Queues;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.decce.ixeris.core.glfw.callback_dispatcher.CursorPosCallbackDispatcher;

public class RenderThreadDispatcher {
    private static volatile boolean suppressCursorPosCallbacks;
    private static final ConcurrentLinkedQueue<Runnable> recordingQueue;

    public static void runLater(Runnable runnable) {
        if (suppressCursorPosCallbacks && runnable instanceof CursorPosCallbackDispatcher.DispatchedRunnable) {
            return;
        }
        recordingQueue.add(runnable);
    }

    public static void replayQueue() {
        Runnable nextTask;
        while ((nextTask = recordingQueue.poll()) != null) {
            nextTask.run();
        }
    }

    public static void clearQueuedCursorPosCallbacks() {
        recordingQueue.removeIf(r -> r instanceof CursorPosCallbackDispatcher.DispatchedRunnable);
    }

    public static void suppressCursorPosCallbacks(boolean suppress) {
        suppressCursorPosCallbacks = suppress;
    }

    static {
        recordingQueue = Queues.newConcurrentLinkedQueue();
    }
}

