/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.classtransform.utils.tree;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.decce.ixeris.core.shadow.classtransform.TransformerManager;
import me.decce.ixeris.core.shadow.classtransform.utils.ASMUtils;
import me.decce.ixeris.core.shadow.classtransform.utils.tree.IClassProvider;
import org.objectweb.asm.tree.ClassNode;

@ParametersAreNonnullByDefault
public class ClassTree {
    private final Map<String, TreePart> tree = new HashMap<String, TreePart>();
    private final TransformerManager transformerManager;

    public ClassTree() {
        this(null);
    }

    public ClassTree(@Nullable TransformerManager transformerManager) {
        this.transformerManager = transformerManager;
    }

    public boolean canTransform() {
        return this.transformerManager != null;
    }

    @Nonnull
    public synchronized TreePart getTreePart(IClassProvider classProvider, String className) throws ClassNotFoundException {
        int oldSize;
        byte[] transformed;
        if (this.tree.containsKey(className = ASMUtils.dot(className))) {
            return this.tree.get(className);
        }
        byte[] bytecode = classProvider.getClass(className);
        if (this.transformerManager != null && (transformed = this.transformerManager.transform(className, bytecode, false)) != null) {
            bytecode = transformed;
        }
        ClassNode node = ASMUtils.fromBytes(bytecode);
        TreePart part = new TreePart(node);
        this.tree.put(className, part);
        do {
            oldSize = part.superClasses.size();
            for (String superClass : part.superClasses.toArray(new String[0])) {
                TreePart superTree = this.getTreePart(classProvider, superClass);
                part.superClasses.addAll(superTree.superClasses);
            }
        } while (oldSize != part.superClasses.size());
        return part;
    }

    @ParametersAreNonnullByDefault
    public class TreePart {
        private final ClassNode node;
        private final String name;
        private final String superClass;
        private final Set<String> superClasses;
        private final int modifiers;

        private TreePart(ClassNode node) {
            this.node = node;
            this.name = ASMUtils.dot(node.name);
            this.superClass = node.superName;
            this.superClasses = new LinkedHashSet<String>();
            if (this.superClass != null) {
                this.superClasses.add(ASMUtils.dot(this.superClass));
            }
            if (node.interfaces != null) {
                for (String inter : node.interfaces) {
                    this.superClasses.add(ASMUtils.dot(inter));
                }
            }
            this.modifiers = node.access;
        }

        public ClassNode getNode() {
            return this.node;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public TreePart parseSuperClass(IClassProvider classProvider) throws ClassNotFoundException {
            if (this.superClass == null) {
                return null;
            }
            return ClassTree.this.getTreePart(classProvider, this.superClass);
        }

        public Set<String> getSuperClasses() {
            return Collections.unmodifiableSet(this.superClasses);
        }

        public Set<TreePart> getParsedSuperClasses(IClassProvider classProvider, boolean includeSelf) throws ClassNotFoundException {
            LinkedHashSet<TreePart> out = new LinkedHashSet<TreePart>();
            if (includeSelf) {
                out.add(this);
            }
            for (String superClass : this.superClasses) {
                out.add(ClassTree.this.getTreePart(classProvider, superClass));
            }
            return out;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TreePart treePart = (TreePart)o;
            return Objects.equals(this.name, treePart.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

