/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.classtransform.mappings;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.decce.ixeris.core.shadow.classtransform.exceptions.FieldNotFoundException;
import me.decce.ixeris.core.shadow.classtransform.exceptions.MethodNotFoundException;
import me.decce.ixeris.core.shadow.classtransform.mappings.annotation.AnnotationRemap;
import me.decce.ixeris.core.shadow.classtransform.mappings.annotation.FillType;
import me.decce.ixeris.core.shadow.classtransform.utils.ASMUtils;
import me.decce.ixeris.core.shadow.classtransform.utils.MemberDeclaration;
import me.decce.ixeris.core.shadow.classtransform.utils.mappings.MapRemapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
class InfoFiller {
    InfoFiller() {
    }

    static void fillInfo(MapRemapper remapper, Object holder, AnnotationRemap remap, Method method, Map<String, Object> values, ClassNode target, ClassNode transformer) {
        if (remap.fill().equals((Object)FillType.SKIP)) {
            return;
        }
        Object value = values.get(method.getName());
        if (method.getReturnType().equals(String.class)) {
            String current = (String)value;
            if (!remap.fill().equals((Object)FillType.KEEP_EMPTY)) {
                List<String> names = InfoFiller.getNames(remapper, holder, remap, current, target, transformer);
                if (names.size() != 1) {
                    throw new MethodNotFoundException(target, transformer, current);
                }
                values.put(method.getName(), names.get(0));
            }
        } else if (method.getReturnType().equals(String[].class)) {
            ArrayList<String> current = (ArrayList<String>)value;
            if (current == null) {
                current = new ArrayList<String>();
            }
            if (current.isEmpty()) {
                if (!remap.fill().equals((Object)FillType.KEEP_EMPTY)) {
                    current.addAll(InfoFiller.getMethodNames(remapper, holder, remap, null, target, transformer));
                }
            } else {
                ArrayList<String> newValues = new ArrayList<String>();
                for (String name : current) {
                    newValues.addAll(InfoFiller.getNames(remapper, holder, remap, name, target, transformer));
                }
                current = newValues;
            }
            values.put(method.getName(), current);
        }
    }

    private static List<String> getNames(MapRemapper remapper, Object holder, AnnotationRemap remap, String current, ClassNode target, ClassNode transformer) {
        if (holder instanceof MethodNode) {
            return InfoFiller.getMethodNames(remapper, holder, remap, current, target, transformer);
        }
        if (holder instanceof FieldNode) {
            return InfoFiller.getFieldNames(remapper, holder, remap, current, target, transformer);
        }
        throw new IllegalArgumentException("Unknown holder type '" + holder.getClass().getName() + "' from transformer '" + transformer.name + "'");
    }

    private static List<String> getMethodNames(MapRemapper remapper, Object holder, AnnotationRemap remap, @Nullable String current, ClassNode target, ClassNode transformer) {
        MemberDeclaration fullDeclaration;
        ArrayList<String> names = new ArrayList<String>();
        if (current == null) {
            MethodNode methodNode = (MethodNode)holder;
            current = methodNode.name + methodNode.desc;
        }
        if (!remapper.isEmpty()) {
            MemberDeclaration fullDeclaration2;
            String originalTarget = remapper.reverse().mapSafe(target.name);
            if (remap.allowClassPrefix() && (fullDeclaration2 = ASMUtils.splitMemberDeclaration(current)) != null) {
                if (!originalTarget.equals(fullDeclaration2.getOwner())) {
                    return Collections.singletonList(current);
                }
                current = fullDeclaration2.getName() + fullDeclaration2.getDesc();
            }
            if (current.contains("(")) {
                String mappedMethodDesc;
                String unmappedMethodDesc;
                String unmappedMethodName = current.substring(0, current.indexOf(40));
                String mappedMethodName = remapper.mapMethodName(originalTarget, unmappedMethodName, unmappedMethodDesc = current.substring(current.indexOf(40)));
                MethodNode methodNode = ASMUtils.getMethod(target, mappedMethodName, mappedMethodDesc = remapper.mapMethodDesc(unmappedMethodDesc));
                if (methodNode == null) {
                    throw new MethodNotFoundException(target, transformer, mappedMethodName + mappedMethodDesc);
                }
                names.add(methodNode.name + methodNode.desc);
            } else {
                String partialMapping = originalTarget + "." + current + "(";
                List<String> partialMappings = remapper.getStartingMappings(partialMapping);
                for (String mapping : partialMappings) {
                    String mappedMethodDesc;
                    String unmappedMethodDesc = mapping.substring(partialMapping.length() - 1);
                    String mappedMethodName = remapper.map(mapping);
                    MethodNode methodNode = ASMUtils.getMethod(target, mappedMethodName, mappedMethodDesc = remapper.mapMethodDesc(unmappedMethodDesc));
                    if (methodNode == null) {
                        throw new MethodNotFoundException(target, transformer, mappedMethodName + mappedMethodDesc);
                    }
                    names.add(methodNode.name + methodNode.desc);
                }
            }
        } else if (remap.allowClassPrefix() && (fullDeclaration = ASMUtils.splitMemberDeclaration(current)) != null) {
            if (!target.name.equals(fullDeclaration.getOwner())) {
                return Collections.singletonList(current);
            }
            current = fullDeclaration.getName() + fullDeclaration.getDesc();
        }
        if (names.isEmpty()) {
            List<MethodNode> methods = ASMUtils.getMethodsFromCombi(target, current);
            if (methods.isEmpty()) {
                throw new MethodNotFoundException(target, transformer, current);
            }
            for (MethodNode method : methods) {
                names.add(method.name + method.desc);
            }
        }
        return names;
    }

    private static List<String> getFieldNames(MapRemapper remapper, Object holder, AnnotationRemap remap, @Nullable String current, ClassNode target, ClassNode transformer) {
        MemberDeclaration fullDeclaration;
        ArrayList<String> names = new ArrayList<String>();
        if (current == null) {
            FieldNode fieldNode = (FieldNode)holder;
            current = fieldNode.name + ":" + fieldNode.desc;
        }
        if (!remapper.isEmpty()) {
            MemberDeclaration fullDeclaration2;
            String originalTarget = remapper.reverse().mapSafe(target.name);
            if (remap.allowClassPrefix() && (fullDeclaration2 = ASMUtils.splitMemberDeclaration(current)) != null) {
                if (!originalTarget.equals(fullDeclaration2.getOwner())) {
                    return Collections.singletonList(current);
                }
                current = fullDeclaration2.getName() + fullDeclaration2.getDesc();
            }
            if (current.contains(":")) {
                String mappedDescriptor;
                String unmappedDescriptor;
                String unmappedName = current.substring(0, current.indexOf(58));
                String mappedFieldName = remapper.mapFieldName(originalTarget, unmappedName, unmappedDescriptor = current.substring(current.indexOf(":") + 1));
                FieldNode fieldNode = ASMUtils.getField(target, mappedFieldName, mappedDescriptor = remapper.mapDesc(unmappedDescriptor));
                if (fieldNode == null) {
                    throw new FieldNotFoundException(target, transformer, mappedFieldName + ":" + mappedDescriptor);
                }
                names.add(fieldNode.name + ":" + fieldNode.desc);
            } else {
                String partialMapping = originalTarget + "." + current + ":";
                List<String> partialMappings = remapper.getStartingMappings(partialMapping);
                for (String mapping : partialMappings) {
                    FieldNode fieldNode;
                    String unmappedDescriptor = mapping.substring(partialMapping.length());
                    String mappedFieldName = remapper.map(mapping);
                    String mappedDescriptor = null;
                    if (!unmappedDescriptor.isEmpty()) {
                        mappedDescriptor = remapper.mapDesc(unmappedDescriptor);
                    }
                    if ((fieldNode = ASMUtils.getField(target, mappedFieldName, mappedDescriptor)) == null) {
                        throw new FieldNotFoundException(target, transformer, mappedFieldName + ":" + mappedDescriptor);
                    }
                    names.add(fieldNode.name + ":" + fieldNode.desc);
                }
            }
        } else if (remap.allowClassPrefix() && (fullDeclaration = ASMUtils.splitMemberDeclaration(current)) != null) {
            if (!target.name.equals(fullDeclaration.getOwner())) {
                return Collections.singletonList(current);
            }
            current = fullDeclaration.getName() + fullDeclaration.getDesc();
        }
        if (names.isEmpty()) {
            List<FieldNode> fields = ASMUtils.getFieldsFromCombi(target, current);
            if (fields.isEmpty()) {
                throw new FieldNotFoundException(target, transformer, current);
            }
            for (FieldNode field : fields) {
                names.add(field.name + ":" + field.desc);
            }
        }
        return names;
    }
}

