/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.callback_dispatcher;

import it.unimi.dsi.fastutil.longs.Long2ReferenceArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.glfw.callback_dispatcher.CommonCallbacks;
import me.decce.ixeris.core.threading.RenderThreadDispatcher;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.system.Callback;

public class CursorPosCallbackDispatcher {
    private static final Long2ReferenceMap<CursorPosCallbackDispatcher> instance = Long2ReferenceMaps.synchronize((Long2ReferenceMap)new Long2ReferenceArrayMap(1));
    private final ReferenceArrayList<GLFWCursorPosCallbackI> mainThreadCallbacks = new ReferenceArrayList(1);
    private boolean lastCallbackSet;
    public GLFWCursorPosCallbackI lastCallback;
    public long lastCallbackAddress;
    private final long window;
    public volatile boolean suppressChecks;

    private CursorPosCallbackDispatcher(long window) {
        this.window = window;
    }

    public static CursorPosCallbackDispatcher get(long window) {
        if (window == Ixeris.accessor.getMinecraftWindow()) {
            return (CursorPosCallbackDispatcher)instance.computeIfAbsent(window, CursorPosCallbackDispatcher::new);
        }
        return (CursorPosCallbackDispatcher)instance.get(window);
    }

    public synchronized void registerMainThreadCallback(GLFWCursorPosCallbackI callback) {
        this.mainThreadCallbacks.add((Object)callback);
        this.validate();
    }

    public synchronized long update(long newAddress) {
        this.suppressChecks = true;
        long ret = this.lastCallbackAddress;
        if (newAddress == 0L && this.mainThreadCallbacks.isEmpty()) {
            GLFW.nglfwSetCursorPosCallback((long)this.window, (long)0L);
        } else {
            GLFW.nglfwSetCursorPosCallback((long)this.window, (long)CommonCallbacks.cursorPosCallback.address());
        }
        this.lastCallbackAddress = newAddress;
        if (!this.lastCallbackSet) {
            this.lastCallback = newAddress == 0L ? null : (GLFWCursorPosCallbackI)Callback.get((long)newAddress);
        }
        this.lastCallbackSet = false;
        this.suppressChecks = false;
        return ret;
    }

    public synchronized void update(GLFWCursorPosCallbackI callback) {
        this.lastCallback = callback;
        this.lastCallbackSet = true;
    }

    public synchronized void validate() {
        this.suppressChecks = true;
        long current = GLFW.nglfwSetCursorPosCallback((long)this.window, (long)CommonCallbacks.cursorPosCallback.address());
        if (current == 0L) {
            if (this.mainThreadCallbacks.isEmpty()) {
                GLFW.nglfwSetCursorPosCallback((long)this.window, (long)0L);
            }
        } else if (current != CommonCallbacks.cursorPosCallback.address()) {
            this.lastCallback = (GLFWCursorPosCallbackI)Callback.get((long)current);
            this.lastCallbackAddress = current;
        }
        this.suppressChecks = false;
    }

    public void onCallback(long window, double xpos, double ypos) {
        if (this.window != window) {
            return;
        }
        for (int i = 0; i < this.mainThreadCallbacks.size(); ++i) {
            ((GLFWCursorPosCallbackI)this.mainThreadCallbacks.get(i)).invoke(window, xpos, ypos);
        }
        if (this.lastCallback != null) {
            RenderThreadDispatcher.runLater(() -> {
                if (this.lastCallback != null) {
                    this.lastCallback.invoke(window, xpos, ypos);
                }
            });
        }
    }

    @FunctionalInterface
    public static interface DispatchedRunnable
    extends Runnable {
    }
}

