/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.callback_dispatcher;

import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import me.decce.ixeris.core.glfw.callback_dispatcher.CommonCallbacks;
import me.decce.ixeris.core.threading.RenderThreadDispatcher;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWMonitorCallbackI;
import org.lwjgl.system.Callback;

public class MonitorCallbackDispatcher {
    private static final MonitorCallbackDispatcher instance = new MonitorCallbackDispatcher();
    private final ReferenceArrayList<GLFWMonitorCallbackI> mainThreadCallbacks = new ReferenceArrayList(1);
    private boolean lastCallbackSet;
    public GLFWMonitorCallbackI lastCallback;
    public long lastCallbackAddress;
    public volatile boolean suppressChecks;

    private MonitorCallbackDispatcher() {
    }

    public static MonitorCallbackDispatcher get() {
        return instance;
    }

    public synchronized void registerMainThreadCallback(GLFWMonitorCallbackI callback) {
        this.mainThreadCallbacks.add((Object)callback);
        this.validate();
    }

    public synchronized long update(long newAddress) {
        this.suppressChecks = true;
        long ret = this.lastCallbackAddress;
        if (newAddress == 0L && this.mainThreadCallbacks.isEmpty()) {
            GLFW.nglfwSetMonitorCallback((long)0L);
        } else {
            GLFW.nglfwSetMonitorCallback((long)CommonCallbacks.monitorCallback.address());
        }
        this.lastCallbackAddress = newAddress;
        if (!this.lastCallbackSet) {
            this.lastCallback = newAddress == 0L ? null : (GLFWMonitorCallbackI)Callback.get((long)newAddress);
        }
        this.lastCallbackSet = false;
        this.suppressChecks = false;
        return ret;
    }

    public synchronized void update(GLFWMonitorCallbackI callback) {
        this.lastCallback = callback;
        this.lastCallbackSet = true;
    }

    public synchronized void validate() {
        this.suppressChecks = true;
        long current = GLFW.nglfwSetMonitorCallback((long)CommonCallbacks.monitorCallback.address());
        if (current == 0L) {
            if (this.mainThreadCallbacks.isEmpty()) {
                GLFW.nglfwSetMonitorCallback((long)0L);
            }
        } else if (current != CommonCallbacks.monitorCallback.address()) {
            this.lastCallback = (GLFWMonitorCallbackI)Callback.get((long)current);
            this.lastCallbackAddress = current;
        }
        this.suppressChecks = false;
    }

    public void onCallback(long monitor, int event) {
        for (int i = 0; i < this.mainThreadCallbacks.size(); ++i) {
            ((GLFWMonitorCallbackI)this.mainThreadCallbacks.get(i)).invoke(monitor, event);
        }
        if (this.lastCallback != null) {
            RenderThreadDispatcher.runLater(() -> {
                if (this.lastCallback != null) {
                    this.lastCallback.invoke(monitor, event);
                }
            });
        }
    }

    @FunctionalInterface
    public static interface DispatchedRunnable
    extends Runnable {
    }
}

