/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.state_caching.window;

import java.nio.FloatBuffer;
import me.decce.ixeris.core.glfw.callback_dispatcher.WindowContentScaleCallbackDispatcher;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwWindowCache;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryStack;

public class GlfwWindowContentScaleCache
extends GlfwWindowCache {
    public static final float VALUE_UNINITIALIZED = Float.NEGATIVE_INFINITY;
    private volatile float xscale = Float.NEGATIVE_INFINITY;
    private volatile float yscale = Float.NEGATIVE_INFINITY;

    public GlfwWindowContentScaleCache(long window) {
        super(window);
        WindowContentScaleCallbackDispatcher.get(window).registerMainThreadCallback(this::onWindowContentScaleCallback);
        this.enableCache();
    }

    private void onWindowContentScaleCallback(long window, float xscale, float yscale) {
        if (this.window == window) {
            this.xscale = xscale;
            this.yscale = yscale;
        }
    }

    public void get(float[] xscale, float[] yscale) {
        if (this.xscale == Float.NEGATIVE_INFINITY || this.yscale == Float.NEGATIVE_INFINITY) {
            this.blockingGet();
        }
        xscale[0] = this.xscale;
        yscale[0] = this.yscale;
    }

    public void get(FloatBuffer xscale, FloatBuffer yscale) {
        if (this.xscale == Float.NEGATIVE_INFINITY || this.yscale == Float.NEGATIVE_INFINITY) {
            this.blockingGet();
        }
        xscale.put(this.xscale).flip();
        yscale.put(this.yscale).flip();
    }

    private void blockingGet() {
        this.disableCache();
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer xscale = stack.mallocFloat(1);
            FloatBuffer yscale = stack.mallocFloat(1);
            GLFW.glfwGetWindowContentScale((long)this.window, (FloatBuffer)xscale, (FloatBuffer)yscale);
            this.xscale = xscale.get();
            this.yscale = yscale.get();
        }
        this.enableCache();
    }
}

