/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.callback_dispatcher;

import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import me.decce.ixeris.core.glfw.callback_dispatcher.CommonCallbacks;
import me.decce.ixeris.core.threading.RenderThreadDispatcher;
import me.decce.ixeris.core.util.MemoryHelper;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.system.Callback;

public class ErrorCallbackDispatcher {
    private static final ErrorCallbackDispatcher instance = new ErrorCallbackDispatcher();
    private final ReferenceArrayList<GLFWErrorCallbackI> mainThreadCallbacks = new ReferenceArrayList(1);
    private boolean lastCallbackSet;
    public GLFWErrorCallbackI lastCallback;
    public long lastCallbackAddress;
    public volatile boolean suppressChecks;

    private ErrorCallbackDispatcher() {
    }

    public static ErrorCallbackDispatcher get() {
        return instance;
    }

    public synchronized void registerMainThreadCallback(GLFWErrorCallbackI callback) {
        this.mainThreadCallbacks.add((Object)callback);
        this.validate();
    }

    public synchronized long update(long newAddress) {
        this.suppressChecks = true;
        long ret = this.lastCallbackAddress;
        if (newAddress == 0L && this.mainThreadCallbacks.isEmpty()) {
            GLFW.nglfwSetErrorCallback((long)0L);
        } else {
            GLFW.nglfwSetErrorCallback((long)CommonCallbacks.errorCallback.address());
        }
        this.lastCallbackAddress = newAddress;
        if (!this.lastCallbackSet) {
            this.lastCallback = newAddress == 0L ? null : (GLFWErrorCallbackI)Callback.get((long)newAddress);
        }
        this.lastCallbackSet = false;
        this.suppressChecks = false;
        return ret;
    }

    public synchronized void update(GLFWErrorCallbackI callback) {
        this.lastCallback = callback;
        this.lastCallbackSet = true;
    }

    public synchronized void validate() {
        this.suppressChecks = true;
        long current = GLFW.nglfwSetErrorCallback((long)CommonCallbacks.errorCallback.address());
        if (current == 0L) {
            if (this.mainThreadCallbacks.isEmpty()) {
                GLFW.nglfwSetErrorCallback((long)0L);
            }
        } else if (current != CommonCallbacks.errorCallback.address()) {
            this.lastCallback = (GLFWErrorCallbackI)Callback.get((long)current);
            this.lastCallbackAddress = current;
        }
        this.suppressChecks = false;
    }

    public void onCallback(int error, long description) {
        for (int i = 0; i < this.mainThreadCallbacks.size(); ++i) {
            ((GLFWErrorCallbackI)this.mainThreadCallbacks.get(i)).invoke(error, description);
        }
        if (this.lastCallback != null) {
            long descriptionCopy = MemoryHelper.deepCopy(description);
            RenderThreadDispatcher.runLater(() -> {
                if (this.lastCallback != null) {
                    this.lastCallback.invoke(error, descriptionCopy);
                }
                MemoryHelper.free(descriptionCopy);
            });
        }
    }

    @FunctionalInterface
    public static interface DispatchedRunnable
    extends Runnable {
    }
}

