/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.state_caching.window;

import java.util.concurrent.atomic.AtomicIntegerArray;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.glfw.callback_dispatcher.KeyCallbackDispatcher;
import me.decce.ixeris.core.glfw.state_caching.util.InputModeHelper;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwWindowCache;
import org.lwjgl.glfw.GLFW;

public class GlfwKeyCache
extends GlfwWindowCache {
    public static final int KEY_UNINITIALIZED = -1;
    private final AtomicIntegerArray keys;

    public GlfwKeyCache(long window) {
        super(window);
        KeyCallbackDispatcher.get(window).registerMainThreadCallback(this::onKeyCallback);
        this.keys = new AtomicIntegerArray(349);
        for (int i = 0; i < this.keys.length(); ++i) {
            this.keys.set(i, -1);
        }
        this.enableCache();
    }

    public int get(int key) {
        if (InputModeHelper.isStickyKeys(this.window)) {
            return this.blockingGet(key);
        }
        if (key < 32 || key > 348) {
            if (Ixeris.getConfig().shouldLogCacheIssues()) {
                Ixeris.LOGGER.warn("A call to glfwGetKey was made with illegal key: {}", (Object)key);
                Thread.dumpStack();
            }
            return this.blockingGet(key);
        }
        int ret = this.keys.get(key);
        if (ret == -1) {
            ret = this.blockingGet(key);
            this.keys.set(key, ret);
        }
        return ret;
    }

    private int blockingGet(int key) {
        this.disableCache();
        int ret = GLFW.glfwGetKey((long)this.window, (int)key);
        this.enableCache();
        return ret;
    }

    private void onKeyCallback(long window, int key, int scancode, int action, int mods) {
        if (this.window == window && key >= 0 && key <= 348) {
            this.keys.set(key, action);
        }
    }
}

