/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.classtransform.transformer.impl.wrapcondition;

import java.lang.reflect.Modifier;
import me.decce.ixeris.core.shadow.classtransform.exceptions.TransformerException;
import me.decce.ixeris.core.shadow.classtransform.transformer.impl.wrapcondition.IWrapConditionTarget;
import me.decce.ixeris.core.shadow.classtransform.utils.ASMUtils;
import me.decce.ixeris.core.shadow.classtransform.utils.Codifier;
import me.decce.ixeris.core.shadow.classtransform.utils.Types;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CWrapConditionMethod
implements IWrapConditionTarget<MethodInsnNode> {
    @Override
    public MethodInsnNode inject(ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod, MethodNode target, MethodInsnNode insnNode) {
        int i;
        boolean isStatic;
        boolean hasArgs = Types.argumentTypes(transformerMethod).length > 0;
        Type[] argumentTypes = Types.argumentTypes(insnNode.desc);
        boolean bl = isStatic = insnNode.getOpcode() == 184;
        if (hasArgs) {
            Type[] expectedArgs;
            if (isStatic) {
                expectedArgs = argumentTypes;
            } else {
                expectedArgs = new Type[argumentTypes.length + 1];
                expectedArgs[0] = Types.type(insnNode.owner);
                System.arraycopy(argumentTypes, 0, expectedArgs, 1, argumentTypes.length);
            }
            if (!ASMUtils.compareTypes(expectedArgs, Types.argumentTypes(transformerMethod))) {
                String message = "must have ";
                message = expectedArgs.length == 1 ? message + "the arguments of the target method" : message + "the instance of the method owner and the arguments of the target method";
                throw new TransformerException(transformerMethod, transformer, message + " as arguments").help(Codifier.of(transformerMethod).param(null).params(expectedArgs));
            }
        }
        int instanceIndex = ASMUtils.getFreeVarIndex(target);
        int[] argIndices = new int[argumentTypes.length];
        for (int i2 = 0; i2 < argumentTypes.length; ++i2) {
            int last = i2 == 0 ? instanceIndex : argIndices[i2 - 1];
            argIndices[i2] = last + argumentTypes[i2].getSize();
        }
        LabelNode end = new LabelNode();
        InsnList insns = new InsnList();
        for (i = argumentTypes.length - 1; i >= 0; --i) {
            insns.add((AbstractInsnNode)new VarInsnNode(argumentTypes[i].getOpcode(54), argIndices[i]));
        }
        if (!isStatic) {
            insns.add((AbstractInsnNode)new VarInsnNode(58, instanceIndex));
        }
        if (!Modifier.isStatic(target.access)) {
            insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        if (hasArgs) {
            if (!isStatic) {
                insns.add((AbstractInsnNode)new VarInsnNode(25, instanceIndex));
            }
            for (i = 0; i < argumentTypes.length; ++i) {
                insns.add((AbstractInsnNode)new VarInsnNode(argumentTypes[i].getOpcode(21), argIndices[i]));
            }
        }
        MethodInsnNode transformerCall = Modifier.isStatic(target.access) ? new MethodInsnNode(184, transformedClass.name, transformerMethod.name, transformerMethod.desc, Modifier.isInterface(transformedClass.access)) : new MethodInsnNode(Modifier.isInterface(transformedClass.access) ? 185 : 182, transformedClass.name, transformerMethod.name, transformerMethod.desc);
        insns.add((AbstractInsnNode)transformerCall);
        insns.add((AbstractInsnNode)new JumpInsnNode(153, end));
        if (!isStatic) {
            insns.add((AbstractInsnNode)new VarInsnNode(25, instanceIndex));
        }
        for (int i3 = 0; i3 < argumentTypes.length; ++i3) {
            insns.add((AbstractInsnNode)new VarInsnNode(argumentTypes[i3].getOpcode(21), argIndices[i3]));
        }
        target.instructions.insertBefore((AbstractInsnNode)insnNode, insns);
        target.instructions.insert((AbstractInsnNode)insnNode, (AbstractInsnNode)end);
        return transformerCall;
    }
}

