/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.classtransform.utils;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.decce.ixeris.core.shadow.classtransform.utils.ASMUtils;
import me.decce.ixeris.core.shadow.classtransform.utils.Types;
import me.decce.ixeris.core.shadow.classtransform.utils.annotations.AnnotationUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@ParametersAreNonnullByDefault
public class CoprocessorUtils {
    @Nullable
    public static AnnotatedParameter[] getAnnotatedParameters(MethodNode methodNode, Class<?> annotationClass) {
        Optional<AnnotationNode[]> optionalAnnotations = AnnotationUtils.findParameterAnnotations(methodNode, annotationClass);
        if (!optionalAnnotations.isPresent()) {
            return null;
        }
        AnnotationNode[] annotations = optionalAnnotations.get();
        Type[] types = Types.argumentTypes(methodNode.desc);
        int[] indices = ASMUtils.getParameterIndices(methodNode);
        if (types.length != annotations.length) {
            throw new RuntimeException("Parameter count does not match annotation count");
        }
        AnnotatedParameter[] annotatedParameters = new AnnotatedParameter[annotations.length];
        int x = 0;
        for (int i = 0; i < annotations.length; ++i) {
            AnnotationNode annotation = annotations[i];
            if (annotation == null) continue;
            String name = null;
            if (methodNode.localVariables != null) {
                for (LocalVariableNode localVariable : methodNode.localVariables) {
                    if (localVariable.index != indices[i]) continue;
                    name = localVariable.name;
                    break;
                }
            }
            annotatedParameters[i] = new AnnotatedParameter(x++, indices[i], name, types[i], annotation);
        }
        return annotatedParameters;
    }

    public static void mergeParametersToArray(MethodNode methodNode, AnnotatedParameter[] annotatedParameters) {
        Type[] types = Types.argumentTypes(methodNode.desc);
        int[] typeIndices = ASMUtils.getParameterIndices(methodNode);
        HashMap<Integer, Integer> indexMappings = new HashMap<Integer, Integer>();
        HashMap<Integer, AnnotatedParameter> arrayMappings = new HashMap<Integer, AnnotatedParameter>();
        ArrayList<Integer> parametersToRemove = new ArrayList<Integer>();
        int currentIndex = Modifier.isStatic(methodNode.access) ? 0 : 1;
        for (int i2 = 0; i2 < types.length; ++i2) {
            Type type = types[i2];
            int index = typeIndices[i2];
            AnnotatedParameter parameter = annotatedParameters[i2];
            if (parameter == null) {
                indexMappings.put(index, currentIndex);
                currentIndex += type.getSize();
                continue;
            }
            parametersToRemove.add(i2);
            arrayMappings.put(index, parameter);
        }
        ASMUtils.removeParameters(methodNode, parametersToRemove.stream().mapToInt(i -> i).toArray());
        ASMUtils.addParameters(methodNode, Types.type(Object[].class));
        for (AbstractInsnNode insn : methodNode.instructions.toArray()) {
            InsnList insns;
            AnnotatedParameter parameter;
            if (insn instanceof VarInsnNode) {
                VarInsnNode varInsnNode = (VarInsnNode)insn;
                if (indexMappings.containsKey(varInsnNode.var)) {
                    varInsnNode.var = (Integer)indexMappings.get(varInsnNode.var);
                    continue;
                }
                if (!arrayMappings.containsKey(varInsnNode.var)) continue;
                parameter = (AnnotatedParameter)arrayMappings.get(varInsnNode.var);
                insns = new InsnList();
                if (varInsnNode.getOpcode() >= 54 && varInsnNode.getOpcode() <= 58) {
                    AbstractInsnNode objectCast = ASMUtils.getPrimitiveToObject(parameter.type);
                    if (objectCast != null) {
                        insns.add(objectCast);
                    }
                    insns.add((AbstractInsnNode)new VarInsnNode(25, currentIndex));
                    insns.add((AbstractInsnNode)new InsnNode(95));
                    insns.add(ASMUtils.intPush(parameter.annotationIndex));
                    insns.add((AbstractInsnNode)new InsnNode(95));
                    insns.add((AbstractInsnNode)new InsnNode(83));
                } else if (varInsnNode.getOpcode() >= 21 && varInsnNode.getOpcode() <= 25) {
                    insns.add((AbstractInsnNode)new VarInsnNode(25, currentIndex));
                    insns.add(ASMUtils.intPush(parameter.annotationIndex));
                    insns.add((AbstractInsnNode)new InsnNode(50));
                    insns.add(ASMUtils.getCast(parameter.type));
                } else {
                    throw new IllegalStateException("Unknown var insn opcode: " + varInsnNode.getOpcode());
                }
                methodNode.instructions.insert((AbstractInsnNode)varInsnNode, insns);
                methodNode.instructions.remove((AbstractInsnNode)varInsnNode);
                continue;
            }
            if (!(insn instanceof IincInsnNode)) continue;
            IincInsnNode iincInsnNode = (IincInsnNode)insn;
            if (indexMappings.containsKey(iincInsnNode.var)) {
                iincInsnNode.var = (Integer)indexMappings.get(iincInsnNode.var);
                continue;
            }
            if (!arrayMappings.containsKey(iincInsnNode.var)) continue;
            parameter = (AnnotatedParameter)arrayMappings.get(iincInsnNode.var);
            insns = new InsnList();
            insns.add((AbstractInsnNode)new VarInsnNode(25, currentIndex));
            insns.add(ASMUtils.intPush(parameter.annotationIndex));
            insns.add((AbstractInsnNode)new InsnNode(92));
            insns.add((AbstractInsnNode)new InsnNode(50));
            insns.add(ASMUtils.getCast(Type.INT_TYPE));
            insns.add(ASMUtils.intPush(iincInsnNode.incr));
            insns.add((AbstractInsnNode)new InsnNode(96));
            insns.add(ASMUtils.getPrimitiveToObject(Type.INT_TYPE));
            insns.add((AbstractInsnNode)new InsnNode(83));
            methodNode.instructions.insert((AbstractInsnNode)iincInsnNode, insns);
            methodNode.instructions.remove((AbstractInsnNode)iincInsnNode);
        }
    }

    public static class AnnotatedParameter {
        private final int annotationIndex;
        private final int index;
        @Nullable
        private final String name;
        private final Type type;
        private final AnnotationNode annotation;

        private AnnotatedParameter(int annotationIndex, int index, @Nullable String name, Type type, AnnotationNode annotation) {
            this.annotationIndex = annotationIndex;
            this.index = index;
            this.name = name;
            this.type = type;
            this.annotation = annotation;
        }

        public int getAnnotationIndex() {
            return this.annotationIndex;
        }

        public int getIndex() {
            return this.index;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public AnnotationNode getAnnotation() {
            return this.annotation;
        }
    }
}

