/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.reflect.wrapper;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.decce.ixeris.core.shadow.reflect.ClassLoaders;
import me.decce.ixeris.core.shadow.reflect.JavaBypass;
import me.decce.ixeris.core.shadow.reflect.stream.RStream;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.ScheduledForRemoval
public class ASMWrapper {
    private static final Class<?> CLASS_Opcodes;
    private static final Class<?> CLASS_ClassWriter;
    private static final Class<?> CLASS_FieldVisitor;
    private static final Class<?> CLASS_MethodVisitor;
    private static final Class<?> CLASS_Label;
    private static final Map<String, Integer> opcodes;
    private final Object classWriter = RStream.of(CLASS_ClassWriter).constructors().by(Integer.TYPE).newInstance(2);

    private static Class<?> forName(String ... names) {
        for (String name : names) {
            try {
                return Class.forName(name);
            }
            catch (Throwable throwable) {
            }
        }
        throw new IllegalStateException("Could not find any of the classes: " + String.join((CharSequence)", ", names));
    }

    public static int opcode(String name) {
        return opcodes.get(name);
    }

    public static String slash(String className) {
        return className.replace('.', '/');
    }

    public static String slash(Class<?> clazz) {
        return ASMWrapper.slash(clazz.getName());
    }

    public static String desc(String className) {
        return "L" + ASMWrapper.slash(className) + ";";
    }

    public static String desc(Class<?> clazz) {
        if (Void.TYPE.equals(clazz)) {
            return "V";
        }
        if (Boolean.TYPE.equals(clazz)) {
            return "Z";
        }
        if (Byte.TYPE.equals(clazz)) {
            return "B";
        }
        if (Short.TYPE.equals(clazz)) {
            return "S";
        }
        if (Character.TYPE.equals(clazz)) {
            return "C";
        }
        if (Integer.TYPE.equals(clazz)) {
            return "I";
        }
        if (Long.TYPE.equals(clazz)) {
            return "J";
        }
        if (Float.TYPE.equals(clazz)) {
            return "F";
        }
        if (Double.TYPE.equals(clazz)) {
            return "D";
        }
        if (clazz.isArray()) {
            return "[" + ASMWrapper.desc(clazz.getComponentType());
        }
        return ASMWrapper.desc(clazz.getName());
    }

    public static String desc(Method method) {
        return ASMWrapper.desc(method.getParameterTypes(), method.getReturnType());
    }

    public static String desc(Class<?>[] parameterTypes, Class<?> returnType) {
        StringBuilder builder = new StringBuilder("(");
        for (Class<?> parameterType : parameterTypes) {
            builder.append(ASMWrapper.desc(parameterType));
        }
        builder.append(")").append(ASMWrapper.desc(returnType));
        return builder.toString();
    }

    public static int getLoadOpcode(Class<?> clazz) {
        if (Boolean.TYPE.equals(clazz) || Byte.TYPE.equals(clazz) || Character.TYPE.equals(clazz) || Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return ASMWrapper.opcode("ILOAD");
        }
        if (Long.TYPE.equals(clazz)) {
            return ASMWrapper.opcode("LLOAD");
        }
        if (Float.TYPE.equals(clazz)) {
            return ASMWrapper.opcode("FLOAD");
        }
        if (Double.TYPE.equals(clazz)) {
            return ASMWrapper.opcode("DLOAD");
        }
        return ASMWrapper.opcode("ALOAD");
    }

    public static int getReturnOpcode(Class<?> clazz) {
        if (Void.TYPE.equals(clazz)) {
            return ASMWrapper.opcode("RETURN");
        }
        if (Boolean.TYPE.equals(clazz) || Byte.TYPE.equals(clazz) || Character.TYPE.equals(clazz) || Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return ASMWrapper.opcode("IRETURN");
        }
        if (Long.TYPE.equals(clazz)) {
            return ASMWrapper.opcode("LRETURN");
        }
        if (Float.TYPE.equals(clazz)) {
            return ASMWrapper.opcode("FRETURN");
        }
        if (Double.TYPE.equals(clazz)) {
            return ASMWrapper.opcode("DRETURN");
        }
        return ASMWrapper.opcode("ARETURN");
    }

    public static ASMWrapper create(int access, @Nonnull String name, @Nullable String signature, @Nonnull String superName, @Nullable String[] interfaces) {
        return new ASMWrapper(access, name, signature, superName, interfaces);
    }

    private <E extends Throwable> ASMWrapper(int access, String name, String signature, String superName, String[] interfaces) throws E {
        MethodHandle visit = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_ClassWriter, "visit", MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class, String.class, String[].class));
        visit.invoke(this.classWriter, ASMWrapper.opcode("V1_8"), access, name, signature, superName, interfaces);
    }

    public void visitField(int access, @Nonnull String name, @Nonnull String descriptor, @Nullable String signature, @Nullable Object value) {
        MethodHandle visitField = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_ClassWriter, "visitField", MethodType.methodType(CLASS_FieldVisitor, Integer.TYPE, String.class, String.class, String.class, Object.class));
        MethodHandle visitEnd = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_FieldVisitor, "visitEnd", MethodType.methodType(Void.TYPE));
        Object fieldVisitor = visitField.invoke(this.classWriter, access, name, descriptor, signature, value);
        visitEnd.invoke(fieldVisitor);
    }

    public MethodVisitorAccess visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodHandle visitMethod = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_ClassWriter, "visitMethod", MethodType.methodType(CLASS_MethodVisitor, Integer.TYPE, String.class, String.class, String.class, String[].class));
        MethodHandle visitCode = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitCode", MethodType.methodType(Void.TYPE));
        Object methodVisitor = visitMethod.invoke(this.classWriter, access, name, descriptor, signature, exceptions);
        visitCode.invoke(methodVisitor);
        return new MethodVisitorAccess(methodVisitor);
    }

    public LabelAccess label() {
        MethodHandle constructor = JavaBypass.TRUSTED_LOOKUP.findConstructor(CLASS_Label, MethodType.methodType(Void.TYPE));
        return new LabelAccess(constructor.invoke());
    }

    public byte[] toByteArray() {
        MethodHandle toByteArray = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_ClassWriter, "toByteArray", MethodType.methodType(byte[].class));
        return toByteArray.invoke(this.classWriter);
    }

    public Class<?> defineAnonymously(Class<?> parent) {
        return ClassLoaders.defineAnonymousClass(parent, this.toByteArray(), new String[0]);
    }

    public Class<?> defineMetafactory(Class<?> parent) {
        return ClassLoaders.defineAnonymousClass(parent, this.toByteArray(), "NESTMATE", "STRONG");
    }

    static {
        opcodes = new HashMap<String, Integer>();
        CLASS_Opcodes = ASMWrapper.forName("org.objectweb.asm.Opcodes", "jdk.internal.org.objectweb.asm.Opcodes");
        CLASS_ClassWriter = ASMWrapper.forName("org.objectweb.asm.ClassWriter", "jdk.internal.org.objectweb.asm.ClassWriter");
        CLASS_FieldVisitor = ASMWrapper.forName("org.objectweb.asm.FieldVisitor", "jdk.internal.org.objectweb.asm.FieldVisitor");
        CLASS_MethodVisitor = ASMWrapper.forName("org.objectweb.asm.MethodVisitor", "jdk.internal.org.objectweb.asm.MethodVisitor");
        CLASS_Label = ASMWrapper.forName("org.objectweb.asm.Label", "jdk.internal.org.objectweb.asm.Label");
        RStream.of(CLASS_Opcodes).fields().filter(true).filter(Integer.TYPE).forEach(f -> opcodes.put(f.name(), (Integer)f.get()));
    }

    public static class LabelAccess {
        private final Object label;

        private LabelAccess(Object label) {
            this.label = label;
        }

        public boolean isNull() {
            return this.label == null;
        }
    }

    public static class MethodVisitorAccess {
        private final Object methodVisitor;

        private MethodVisitorAccess(Object methodVisitor) {
            this.methodVisitor = methodVisitor;
        }

        public boolean isNull() {
            return this.methodVisitor == null;
        }

        public void visitInsn(int opcode) {
            MethodHandle visitInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitInsn", MethodType.methodType(Void.TYPE, Integer.TYPE));
            visitInsn.invoke(this.methodVisitor, opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            MethodHandle visitIntInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitIntInsn", MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE));
            visitIntInsn.invoke(this.methodVisitor, opcode, operand);
        }

        public void visitVarInsn(int opcode, int varIndex) {
            MethodHandle visitVarInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitVarInsn", MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE));
            visitVarInsn.invoke(this.methodVisitor, opcode, varIndex);
        }

        public void visitTypeInsn(int opcode, String type) {
            MethodHandle visitTypeInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitTypeInsn", MethodType.methodType(Void.TYPE, Integer.TYPE, String.class));
            visitTypeInsn.invoke(this.methodVisitor, opcode, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            MethodHandle visitFieldInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitFieldInsn", MethodType.methodType(Void.TYPE, Integer.TYPE, String.class, String.class, String.class));
            visitFieldInsn.invoke(this.methodVisitor, opcode, owner, name, descriptor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            MethodHandle visitMethodInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitMethodInsn", MethodType.methodType(Void.TYPE, Integer.TYPE, String.class, String.class, String.class, Boolean.TYPE));
            visitMethodInsn.invoke(this.methodVisitor, opcode, owner, name, descriptor, isInterface);
        }

        public void visitJumpInsn(int opcode, LabelAccess target) {
            MethodHandle visitJumpInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitJumpInsn", MethodType.methodType(Void.TYPE, Integer.TYPE, CLASS_Label));
            visitJumpInsn.invoke(this.methodVisitor, opcode, target.label);
        }

        public void visitLabel(LabelAccess label) {
            MethodHandle visitLabel = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitLabel", MethodType.methodType(Void.TYPE, CLASS_Label));
            visitLabel.invoke(this.methodVisitor, label.label);
        }

        public void visitLdcInsn(Object value) {
            MethodHandle visitLdcInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitLdcInsn", MethodType.methodType(Void.TYPE, Object.class));
            visitLdcInsn.invoke(this.methodVisitor, value);
        }

        public void visitIincInsn(int varIndex, int increment) {
            MethodHandle visitIincInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitIincInsn", MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE));
            visitIincInsn.invoke(this.methodVisitor, varIndex, increment);
        }

        public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
            MethodHandle visitMultiANewArrayInsn = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitMultiANewArrayInsn", MethodType.methodType(Void.TYPE, String.class, Integer.TYPE));
            visitMultiANewArrayInsn.invoke(this.methodVisitor, descriptor, numDimensions);
        }

        public void visitTryCatchBlock(LabelAccess start, LabelAccess end, LabelAccess handler, String type) {
            MethodHandle visitTryCatchBlock = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitTryCatchBlock", MethodType.methodType(Void.TYPE, CLASS_Label, CLASS_Label, CLASS_Label, String.class));
            visitTryCatchBlock.invoke(this.methodVisitor, start.label, end.label, handler.label, type);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            MethodHandle visitMaxs = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitMaxs", MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE));
            visitMaxs.invoke(this.methodVisitor, maxStack, maxLocals);
        }

        public void visitEnd() {
            MethodHandle visitEnd = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_MethodVisitor, "visitEnd", MethodType.methodType(Void.TYPE));
            visitEnd.invoke(this.methodVisitor);
        }
    }
}

