/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.util;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import me.decce.ixeris.core.shadow.classtransform.TransformerManager;
import me.decce.ixeris.core.shadow.classtransform.mixinstranslator.MixinsTranslator;
import me.decce.ixeris.core.shadow.classtransform.transformer.IAnnotationHandlerPreprocessor;
import me.decce.ixeris.core.shadow.classtransform.utils.tree.BasicClassProvider;
import me.decce.ixeris.core.util.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TransformationHelper {
    public static final String MODULE_GLFW = "org.lwjgl.glfw";
    public static final Set<String> LEGAL_BOOTSTRAP_CLASSLOADERS = Set.of("MC-BOOTSTRAP", "SECURE-BOOTSTRAP", "app");
    public static final Set<String> LEGAL_MOD_CLASSLOADERS = Set.of("LAYER SERVICE", "TRANSFORMER", "FML Early Services");
    public final MethodHandle DEFINE_CLASS = ReflectionHelper.unreflect(() -> ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE));
    public final MethodHandle RESOLVE_CLASS = ReflectionHelper.unreflect(() -> ClassLoader.class.getDeclaredMethod("resolveClass", Class.class));
    public final MethodHandle IMPL_ADD_READS_ALL_UNNAMED = ReflectionHelper.unreflect(() -> Module.class.getDeclaredMethod("implAddReadsAllUnnamed", new Class[0]));
    public final MethodHandle IMPL_ADD_READS = ReflectionHelper.unreflect(() -> Module.class.getDeclaredMethod("implAddReads", Module.class));
    protected final Logger LOGGER = LogManager.getLogger();
    public final ClassLoader mcBootstrapClassLoader;
    public final ClassLoader modClassLoader;

    public TransformationHelper(ClassLoader mcBootstrapClassLoader, ClassLoader modClassLoader) {
        this.mcBootstrapClassLoader = mcBootstrapClassLoader;
        this.modClassLoader = modClassLoader;
    }

    public static Module findBootModule(String name) {
        ModuleLayer layer = (ModuleLayer)((IModuleLayerManager)Launcher.INSTANCE.findLayerManager().orElseThrow()).getLayer(IModuleLayerManager.Layer.BOOT).orElseThrow();
        return layer.findModule(name).orElseThrow();
    }

    protected Module findGlfwModule() {
        return TransformationHelper.findBootModule(MODULE_GLFW);
    }

    protected Module findLog4jModule() {
        return TransformationHelper.findBootModule("org.apache.logging.log4j");
    }

    public void expandGlfwModuleReads() {
        try {
            this.LOGGER.debug("Trying to expand GLFW module reads");
            Module glfwModule = this.findGlfwModule();
            this.addReads(glfwModule, this.findLog4jModule());
            this.IMPL_ADD_READS_ALL_UNNAMED.invoke(glfwModule);
            this.LOGGER.debug("Successfully expanded GLFW module reads");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void addReads(Module thisModule, Module thatModule) throws Throwable {
        if (!thisModule.toString().equals(thatModule.toString())) {
            this.IMPL_ADD_READS.invoke(thisModule, thatModule);
        }
    }

    public byte[] doTransformation(Class<?>[] transformers, boolean useMixinsTranslator, IAnnotationHandlerPreprocessor ... additionalPreprocessor) {
        byte[] byArray;
        block8: {
            InputStream is = this.mcBootstrapClassLoader.getResourceAsStream("org/lwjgl/glfw/GLFW.class");
            try {
                byte[] bytes = Objects.requireNonNull(is).readAllBytes();
                TransformerManager manager = this.getTransformerManager(transformers, useMixinsTranslator, additionalPreprocessor);
                long millis = System.currentTimeMillis();
                byte[] transformedBytes = manager.transform("org.lwjgl.glfw.GLFW", bytes);
                long elapsed = System.currentTimeMillis() - millis;
                this.LOGGER.info("Successfully transformed class org.lwjgl.glfw.GLFW in {}ms", (Object)elapsed);
                byArray = transformedBytes;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return byArray;
    }

    public void verifyClassLoaders() {
        if (!LEGAL_BOOTSTRAP_CLASSLOADERS.contains(this.mcBootstrapClassLoader.getName())) {
            throw new IllegalStateException("IxerisBootstrapper found incorrect MC-BOOTSTRAP classloader: " + this.mcBootstrapClassLoader.getName());
        }
        if (!LEGAL_MOD_CLASSLOADERS.contains(this.modClassLoader.getName())) {
            throw new IllegalStateException("IxerisBootstrapper found incorrect mod classloader: " + this.modClassLoader.getName());
        }
    }

    public static String toClassName(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name.replace(".class", "").replace('/', '.');
    }

    public void loadCoreClasses(Class<?> serviceClass) {
        this.LOGGER.info("Loading Ixeris coremod");
        URL resource = serviceClass.getResource("/me/decce/ixeris/core");
        try (Stream<Path> stream = this.walkResource(Objects.requireNonNull(resource).toURI());){
            LinkedList<Path> classesToLoad = new LinkedList<Path>(stream.filter(p -> !Files.isDirectory(p, new LinkOption[0]) && p.toString().endsWith(".class")).toList());
            while (!classesToLoad.isEmpty()) {
                Path clazz = classesToLoad.remove(0);
                if (this.loadClass(clazz)) continue;
                classesToLoad.add(clazz);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected Stream<Path> walkResource(URI resource) throws URISyntaxException, IOException {
        return Files.walk(Path.of(resource), new FileVisitOption[0]);
    }

    private boolean loadClass(Path path) {
        try {
            String name = TransformationHelper.toClassName(path.toString());
            this.defineClass(this.mcBootstrapClassLoader, name, Files.readAllBytes(path));
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void defineClass(ClassLoader cl, String name, byte[] bytes) throws Throwable {
        Class clazz = this.DEFINE_CLASS.invoke(cl, name, bytes, 0, bytes.length);
        this.RESOLVE_CLASS.invoke(cl, clazz);
    }

    protected TransformerManager getTransformerManager(Class<?>[] transformers, boolean useMixinsTranslator, IAnnotationHandlerPreprocessor ... additionalPreprocessor) {
        BasicClassProvider provider = new BasicClassProvider();
        TransformerManager manager = new TransformerManager(provider);
        if (useMixinsTranslator) {
            manager.addTransformerPreprocessor((IAnnotationHandlerPreprocessor)new MixinsTranslator());
        }
        for (IAnnotationHandlerPreprocessor preprocessor : additionalPreprocessor) {
            manager.addTransformerPreprocessor(preprocessor);
        }
        for (Class<?> transformer : transformers) {
            manager.addTransformer(transformer.getName());
        }
        return manager;
    }

    public abstract void removeModClassesFromServiceLayer();
}

