/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.forge;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Objects;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.shadow.classtransform.transformer.IAnnotationHandlerPreprocessor;
import me.decce.ixeris.core.shadow.reflect.Agents;
import me.decce.ixeris.core.util.TransformationHelper;
import me.decce.ixeris.forge.ForgeTransformationHelper;
import me.decce.ixeris.forge.transformers.callback_dispatcher.GLFWTransformer;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;

public class IxerisTransformer {
    private final Logger LOGGER = LogManager.getLogger();
    private final TransformationHelper helper = new ForgeTransformationHelper(Logger.class.getClassLoader(), this.getClass().getClassLoader());
    private final Class<?>[] TRANSFORMERS = new Class[]{me.decce.ixeris.forge.transformers.GLFWTransformer.class, GLFWTransformer.class, me.decce.ixeris.forge.transformers.glfw_state_caching.GLFWTransformer.class, me.decce.ixeris.forge.transformers.glfw_threading.GLFWTransformer.class};

    public void run() {
        if (!IxerisTransformer.isOnClient()) {
            this.LOGGER.info("Skipped Ixeris bootstrapping because: on dedicated server");
            return;
        }
        this.helper.verifyClassLoaders();
        this.helper.loadCoreClasses(this.getClass());
        this.LOGGER.info("Attempting to transform org.lwjgl.glfw.GLFW");
        this.helper.expandGlfwModuleReads();
        byte[] bytes = this.helper.doTransformation(this.TRANSFORMERS, false, new IAnnotationHandlerPreprocessor[0]);
        try {
            this.redefineGlfw(bytes);
        }
        catch (ClassNotFoundException | UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
        this.helper.removeModClassesFromServiceLayer();
        this.temporarilySuppressEventPollingWarning();
    }

    private Instrumentation getInstrumentation() {
        try {
            return Objects.requireNonNull(Agents.getInstrumentation());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void redefineGlfw(byte[] bytes) throws UnmodifiableClassException, ClassNotFoundException {
        Instrumentation instrumentation = this.getInstrumentation();
        instrumentation.redefineClasses(new ClassDefinition(GLFW.class, bytes));
    }

    private void temporarilySuppressEventPollingWarning() {
        Ixeris.suppressEventPollingWarning = true;
    }

    public static boolean isOnClient() {
        return FMLLoader.getDist().isClient();
    }
}

