/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.callback_dispatcher;

import it.unimi.dsi.fastutil.longs.Long2ReferenceArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import me.decce.ixeris.core.glfw.callback_dispatcher.CommonCallbacks;
import me.decce.ixeris.core.threading.RenderThreadDispatcher;
import me.decce.ixeris.core.util.MemoryHelper;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWDropCallback;
import org.lwjgl.glfw.GLFWDropCallbackI;
import org.lwjgl.system.Callback;

public class DropCallbackDispatcher {
    private static final Long2ReferenceMap<DropCallbackDispatcher> instance = new Long2ReferenceArrayMap(1);
    private final ReferenceArrayList<GLFWDropCallbackI> mainThreadCallbacks = new ReferenceArrayList(1);
    private boolean lastCallbackSet;
    public GLFWDropCallbackI lastCallback;
    public long lastCallbackAddress;
    private final long window;
    public volatile boolean suppressChecks;

    private DropCallbackDispatcher(long window) {
        this.window = window;
    }

    public static synchronized DropCallbackDispatcher get(long window) {
        if (!instance.containsKey(window)) {
            instance.put(window, (Object)new DropCallbackDispatcher(window));
            ((DropCallbackDispatcher)instance.get(window)).validate();
        }
        return (DropCallbackDispatcher)instance.get(window);
    }

    public synchronized void registerMainThreadCallback(GLFWDropCallbackI callback) {
        this.mainThreadCallbacks.add((Object)callback);
        this.validate();
    }

    public synchronized long update(long newAddress) {
        this.suppressChecks = true;
        long ret = this.lastCallbackAddress;
        if (newAddress == 0L && this.mainThreadCallbacks.isEmpty()) {
            GLFW.nglfwSetDropCallback((long)this.window, (long)0L);
        } else {
            GLFW.nglfwSetDropCallback((long)this.window, (long)CommonCallbacks.dropCallback.address());
        }
        this.lastCallbackAddress = newAddress;
        if (!this.lastCallbackSet) {
            this.lastCallback = newAddress == 0L ? null : (GLFWDropCallbackI)Callback.get((long)newAddress);
        }
        this.lastCallbackSet = false;
        this.suppressChecks = false;
        return ret;
    }

    public synchronized void update(GLFWDropCallbackI callback) {
        this.lastCallback = callback;
        this.lastCallbackSet = true;
    }

    public synchronized void validate() {
        this.suppressChecks = true;
        long current = GLFW.nglfwSetDropCallback((long)this.window, (long)CommonCallbacks.dropCallback.address());
        if (current == 0L) {
            if (this.mainThreadCallbacks.isEmpty()) {
                GLFW.nglfwSetDropCallback((long)this.window, (long)0L);
            }
        } else if (current != CommonCallbacks.dropCallback.address()) {
            this.lastCallback = (GLFWDropCallbackI)Callback.get((long)current);
            this.lastCallbackAddress = current;
        }
        this.suppressChecks = false;
    }

    public void onCallback(long window, int count, long names) {
        if (this.window != window) {
            return;
        }
        for (int i = 0; i < this.mainThreadCallbacks.size(); ++i) {
            ((GLFWDropCallbackI)this.mainThreadCallbacks.get(i)).invoke(window, count, names);
        }
        if (this.lastCallback != null) {
            long namesCopy = MemoryHelper.deepCopy(names, count, GLFWDropCallback::getName);
            RenderThreadDispatcher.runLater(() -> {
                if (this.lastCallback != null) {
                    this.lastCallback.invoke(window, count, namesCopy);
                }
                MemoryHelper.free(namesCopy, count);
            });
        }
    }

    @FunctionalInterface
    public static interface DispatchedRunnable
    extends Runnable {
    }
}

