/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.state_caching.window;

import java.nio.IntBuffer;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwWindowCache;
import org.lwjgl.system.MemoryStack;

public abstract class GlfwAbstractSizeCache
extends GlfwWindowCache {
    public static final int VALUE_UNINITIALIZED = -1;
    protected volatile int width = -1;
    protected volatile int height = -1;

    protected GlfwAbstractSizeCache(long window) {
        super(window);
        this.registerCallback();
        this.enableCache();
    }

    protected void onAbstractSizeCallback(long window, int width, int height) {
        if (this.window == window) {
            this.width = width;
            this.height = height;
        }
    }

    public void get(int[] width, int[] height) {
        if (this.width == -1 || this.height == -1) {
            this.blockingGet();
        }
        width[0] = this.width;
        height[0] = this.height;
    }

    public void get(IntBuffer width, IntBuffer height) {
        if (this.width == -1 || this.height == -1) {
            this.blockingGet();
        }
        width.put(width.position(), this.width);
        height.put(height.position(), this.height);
    }

    private void blockingGet() {
        this.disableCache();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer width = stack.mallocInt(1);
            IntBuffer height = stack.mallocInt(1);
            this.blockingGet(this.window, width, height);
            this.width = width.get();
            this.height = height.get();
        }
        this.enableCache();
    }

    protected abstract void registerCallback();

    protected abstract void blockingGet(long var1, IntBuffer var3, IntBuffer var4);
}

