/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.transform;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.invoke.MethodHandle;
import me.decce.ixeris.core.shadow.classtransform.TransformerManager;
import me.decce.ixeris.core.shadow.classtransform.mixinstranslator.MixinsTranslator;
import me.decce.ixeris.core.shadow.classtransform.transformer.IAnnotationHandlerPreprocessor;
import me.decce.ixeris.core.shadow.classtransform.utils.tree.BasicClassProvider;
import me.decce.ixeris.core.util.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TransformationHelper {
    public static final String MODULE_GLFW = "org.lwjgl.glfw";
    public final MethodHandle IMPL_ADD_READS_ALL_UNNAMED = ReflectionHelper.unreflect(() -> Module.class.getDeclaredMethod("implAddReadsAllUnnamed", new Class[0]));
    public final MethodHandle IMPL_ADD_READS = ReflectionHelper.unreflect(() -> Module.class.getDeclaredMethod("implAddReads", Module.class));
    protected final Logger LOGGER = LogManager.getLogger();
    public final ClassLoader modClassLoader;

    public TransformationHelper(ClassLoader modClassLoader) {
        this.modClassLoader = modClassLoader;
    }

    public static Module findBootModule(String name) {
        ModuleLayer layer = (ModuleLayer)((IModuleLayerManager)Launcher.INSTANCE.findLayerManager().orElseThrow()).getLayer(IModuleLayerManager.Layer.BOOT).orElseThrow();
        return layer.findModule(name).orElseThrow();
    }

    protected abstract Class<?>[] getTransformers();

    protected Module findGlfwModule() {
        return TransformationHelper.findBootModule(MODULE_GLFW);
    }

    protected Module findLog4jModule() {
        return TransformationHelper.findBootModule("org.apache.logging.log4j");
    }

    public void expandGlfwModuleReads() {
        try {
            this.LOGGER.debug("Trying to expand GLFW module reads");
            Module glfwModule = this.findGlfwModule();
            this.addReads(glfwModule, this.findLog4jModule());
            this.IMPL_ADD_READS_ALL_UNNAMED.invoke(glfwModule);
            this.LOGGER.debug("Successfully expanded GLFW module reads");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void addReads(Module thisModule, Module thatModule) throws Throwable {
        if (!thisModule.toString().equals(thatModule.toString())) {
            this.IMPL_ADD_READS.invoke(thisModule, thatModule);
        }
    }

    public byte[] doTransformation(String className, byte[] classBytes, boolean useMixinsTranslator, IAnnotationHandlerPreprocessor ... additionalPreprocessor) {
        TransformerManager manager = this.getTransformerManager(this.getTransformers(), useMixinsTranslator, additionalPreprocessor);
        long millis = System.currentTimeMillis();
        byte[] transformedBytes = manager.transform(className, classBytes);
        long elapsed = System.currentTimeMillis() - millis;
        this.LOGGER.info("Successfully transformed class {} in {}ms", (Object)className, (Object)elapsed);
        return transformedBytes;
    }

    protected TransformerManager getTransformerManager(Class<?>[] transformers, boolean useMixinsTranslator, IAnnotationHandlerPreprocessor ... additionalPreprocessor) {
        BasicClassProvider provider = new BasicClassProvider(this.modClassLoader);
        TransformerManager manager = new TransformerManager(provider);
        if (useMixinsTranslator) {
            manager.addTransformerPreprocessor((IAnnotationHandlerPreprocessor)new MixinsTranslator());
        }
        for (IAnnotationHandlerPreprocessor preprocessor : additionalPreprocessor) {
            manager.addTransformerPreprocessor(preprocessor);
        }
        for (Class<?> transformer : transformers) {
            manager.addTransformer(transformer.getName());
        }
        return manager;
    }
}

