/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.state_caching.window;

import me.decce.ixeris.core.glfw.callback_dispatcher.CursorEnterCallbackDispatcher;
import me.decce.ixeris.core.glfw.callback_dispatcher.WindowFocusCallbackDispatcher;
import me.decce.ixeris.core.glfw.callback_dispatcher.WindowIconifyCallbackDispatcher;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwWindowCache;
import me.decce.ixeris.core.util.PlatformHelper;
import org.lwjgl.glfw.GLFW;

public class GlfwWindowAttribCache
extends GlfwWindowCache {
    public static final int VALUE_UNINITIALIZED = -1;
    private volatile int focused = -1;
    private volatile int iconified = -1;
    private volatile int hovered = -1;

    public GlfwWindowAttribCache(long window) {
        super(window);
        CursorEnterCallbackDispatcher.get(window).registerMainThreadCallback(this::onCursorEnterCallback);
        WindowFocusCallbackDispatcher.get(window).registerMainThreadCallback(this::onWindowFocusCallback);
        WindowIconifyCallbackDispatcher.get(window).registerMainThreadCallback(this::onWindowIconifyCallback);
        this.enableCache();
    }

    private void onCursorEnterCallback(long window, boolean entered) {
        if (this.window == window) {
            this.hovered = entered ? 1 : 0;
        }
    }

    private void onWindowFocusCallback(long window, boolean focused) {
        if (this.window == window) {
            this.focused = focused ? 1 : 0;
        }
    }

    private void onWindowIconifyCallback(long window, boolean iconified) {
        if (this.window == window) {
            this.iconified = iconified ? 1 : 0;
        }
    }

    public int get(int attrib) {
        switch (attrib) {
            case 131083: {
                if (this.hovered == -1) {
                    this.hovered = this.blockingGet(attrib);
                }
                return this.hovered;
            }
            case 131073: {
                if (this.focused == -1) {
                    this.focused = this.blockingGet(attrib);
                }
                return this.focused;
            }
            case 131074: {
                if (this.iconified == -1) {
                    if (PlatformHelper.isLinux()) {
                        return this.blockingGet(attrib);
                    }
                    this.iconified = this.blockingGet(attrib);
                }
                return this.iconified;
            }
        }
        return this.blockingGet(attrib);
    }

    private int blockingGet(int attrib) {
        this.disableCache();
        int ret = GLFW.glfwGetWindowAttrib((long)this.window, (int)attrib);
        this.enableCache();
        return ret;
    }
}

